#include <glib.h>
#include <stdlib.h>
#include <math.h>
#include "md.h"
#include "rtf.h"
#include "param.h"
#include "defs.h"
#include "send_molecule.h"


static void 
shakeup (GList *bond_list, GList *ang_list)
{
  gint nbond, nang;
  gint i;
  GList *list;
    
  nbond = g_list_length (bond_list);
  nang  = g_list_length (ang_list);
  
  nrat = nbond+nang;
  
  rat = g_new0 (MD_Rattle, nrat);
  
  for (i = 0, list = bond_list; list; list = list->next, i++)
    {
      Bond *bond = (Bond *) list->data;

      if (bond->iatom1 < bond->iatom2)
	{
	  rat[i].ia1 = bond->iatom1;
	  rat[i].ia2 = bond->iatom2;
	}
      else
	{
	  rat[i].ia2 = bond->iatom1;
	  rat[i].ia1 = bond->iatom2;
	}
      rat[i].dist = get_bond_value (vdw_type[bond->iatom1],
				    vdw_type[bond->iatom2]);
    }
  
  for (list = ang_list; list; list = list->next)
    {
      /*
      Angle *angle = (Angle *) list->data;
      irat[i][0] = angle->iatom1;
      irat[i][1] = angle->iatom2;
      */
    }
  
}

static void
rand_vec (vector3 *vec)
{
  double x, y, z;
  double s;
  
  s = 2.0;
  
  while (s > 1.0)
    {
      x = 2.0 * drand48 () - 1.0;
      y = 2.0 * drand48 () - 1.0;
      s = x*x + y*y;
    }
  
  vec->z = 1.0 - 2.0 * s;
  s = 2.0 * sqrt (1.0 - s);
  vec->y = s * y;
  vec->x = s * x;
}

  
gboolean
md_init (Molecule *mol)
{
  gboolean ok = TRUE;
  gint nres;
  GList *list, *list_j;
  gint  i, j;
  vector3 imp;
  vector3 vec;
  gdouble v;
  
  /* --- initiate send_molecule --- */
  send_molecule_init (mol);

  /* -- read rtf file -- */
  ok = read_rtf (control.rtf_fname);

  if (!ok)
    return ok;
  
  /* -- read param file -- */
  ok = read_param (control.prm_fname);

  if (!ok)
    return ok;

  /* -- Allocate Position, Velocities, and Accelerations --- */

  natoms = g_list_length (mol->atom_list);
  nres   = g_list_length (mol->res_list);
 
  /* -- Initialize position -- */
  r = g_new0 (vector3*, natoms);
  
  for (i = 0, list = mol->pos_list; list; list = list->next, i++)
    {
      r[i] = (vector3*)list->data;
    }

  /* -- Initialize Mass -- */
  mass = g_new0 (double, natoms);
  charge = g_new0 (double, natoms);
  vdw_type = g_new0 (double, natoms);
  
  for (i = 0, list = mol->atom_list; list; list = list->next, i++)
    {
      AtomInfo *atom = (AtomInfo *)list->data;
      
      mass[i] = atom->mass;
      charge[i] = atom->charge;
      vdw_type[i] = get_vdw_type (atom->type);
    }

  /* --- Initialize A[][] , B[][] for LJ potential --- */

  setup_vdw_table ();  /* read_param.c */
  
  /* --- Initialize velocities -- */
  vel = g_new0 (vector3, natoms);
  acc = g_new0 (vector3, natoms);
  imp.x = 0.;
  imp.y = 0.;
  imp.z = 0.;
  Ukin = 0.0;

#ifdef DEBUG_  
  g_print (" kB is %f \n", kB);
#endif

  for (i = 0; i < natoms; i++)
    {
      v = gauss_rand () * sqrt (2. * kB * control.temp/ mass[i]);
      rand_vec (&vec);
      
      vel[i].x = v * vec.x;
      vel[i].y = v * vec.y;
      vel[i].z = v * vec.z;
      
      imp.x += vel[i].x;
      imp.y += vel[i].y;
      imp.z += vel[i].z;
  
      Ukin += 0.5 * mass[i] * (vel[i].x * vel[i].x
			       + vel[i].y * vel[i].y + vel[i].z * vel[i].z);
      
    }
#ifdef DEBUG_
  g_print ("Ukin = %f , natoms = %d , temper = %f Ukin/natoms = %f \n",
	   Ukin, natoms, control.temp, Ukin/natoms);
#endif
  
  imp.x /= (double) natoms;
  imp.y /= (double) natoms;
  imp.z /= (double) natoms;
  
  Ukin = 0.0;
  
  for (i = 0; i < natoms; i++)
    {
      vel[i].x -= imp.x;
      vel[i].y -= imp.y;
      vel[i].z -= imp.z;
      
      Ukin += 0.5 * mass[i] * (vel[i].x * vel[i].x
			       + vel[i].y * vel[i].y + vel[i].z * vel[i].z);
    }

#ifdef DEBUG_  
  g_print ("Ukin = %f , natoms = %d , temper = %f Ukin/natoms = %f\n",
	   Ukin, natoms, control.temp, Ukin/natoms);
#endif


  /* --- Initiate force -- */
  fr = g_new0 (vector3, natoms);


  
  shakeup (mol->bond_list, NULL);
  
  /*
    Minimize 
  */

  return TRUE;
  
}

