#include <glib.h>
#include "math.h"
#include "md.h"
#include "send_molecule.h"

void
md_loop ()
{
  int i;
  gboolean need_verlet_list_init = TRUE;
  vector3 imp;
  
  for (i = 0; i < control.nsteps; i++)
    {
      /* calculate force */
      force (need_verlet_list_init);
      
       /* integrate the equation of motion */
      integrate (i, &imp); 

      send_molecule ();
      
    }
  
  
}

#ifdef _MD__
void
md_loop ()
{
  double av[6], tempz;
  vector3 imp;
  int i;
  gboolean need_verlet_list_init;
  
  for (i = 0; i < 6; i++)
    av[i] = 0.0;
  
  /* initialize radial distribution function */
  sample_gyra (1);
  
  /* initialize diffusion coefficient */
  /*  sample_diff (1); */
  
  for (i = 0; i < nstep; i++)
    {
      /* calculate force */
      force (need_verlet_list_init);
  
      /* integrate the equation of motion */
      integrate (i, &imp);
  
      if (i == 0)
	{
	}
      
      Utot = Ukin + Upot;
      
      tempz = 2.0 * Ukin / (3. * npart - 3);
      
      if (i > ninit && (i+1) % 50 == 0)
	{
	}
      if ((i+1) % 100 == 0)
	{
	  
	}
      if ((i+1) == nstep)
	{
	  
	}
      
      if (nstep > ninit)
	{
	  av[0] += tempz;
	  av[1] += press;
	  av[2] += Ukin;
	  av[3] += Upot;
	  av[4] += Utot;
	  av[5] += 1.0;
	}
      
      if ((i+1)%100 == 0)
	{
	  
	}
      
    }
}

#endif
