#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <gnome.h>
#include "md.h"

int
md_main (Molecule *mol, char *control_fname)
{
  gboolean ok;
  
  /*
  smdrand (1000);
  */
  g_print ("In md_main \n");
  
  /* read data from disk */
  ok = md_read_control (control_fname);
  
  if (!ok)
    {
      g_message ("md_main : Fail to md_read_control");
      return ok;
    }
  
  /* general initial coordinates/velocities */
  ok = md_init (mol);
  
  if (!ok)
    return ok;
  
  /* finally, perform a MD simulation */
  md_loop ();

  g_print ("the end of md_main \n");
  
  return TRUE;
  
}
