#ifndef _DND_PARAM_H
#define _DND_PARAM_H

#include "rtf.h"

GList *param_bond_list;
GList *param_angle_list;
GList *param_dihedral_list;
GList *param_improper_list;
GList *hbond_param_list;

gboolean read_param (char *fname);
gdouble get_bond_value (int at1, int at2);
gdouble get_angle_value (RTF_AtomType *at1, RTF_AtomType *at2,
			 RTF_AtomType *at3);
void setup_vdw_table ();

typedef struct _param_bond         ParamBond;
typedef struct _param_angle        ParamAngle;
typedef struct _param_dihedral     ParamDihedral;
typedef struct _param_improper     ParamImproper;
typedef struct _param_nonbond      ParamNonBond;
typedef struct _param_hbond        ParamHBond;
typedef struct _param_nbond_option ParamNBond;

ParamNBond param_nbond;

struct _param_nbond_option
{
  double cut_off_nb; /* CUTNB = 13 : CUTNB >= CTOFNB+2*TOLE */
  gboolean  do_atom;    /* if ATOM(GROUP) is selected , it is TRUE(FALSE).*/
  double tolerance;  /* tolerance : distance that any atom is allowed to,
			move before list gets updated */
  double warn_min;   /* warning distance */
  double inhibit;    /* factor specifying at which VDW distance
			the nonbonded interactions are truncated*/
  double switch_cut_off_nb;
  double switch_cut_on_nb;
  
  double elec_eps, elec_e14fac;
  gint   elec_option;
  gint   vdw_option;
  gint   exclusion_option;
};

double **A, **B; /* Constant for LJ potential function */


#endif
