#include <math.h>
#include <glib.h>
#include "md.h"

static gboolean *is_update = NULL;
static gboolean *is_moved = NULL;
/*
  From CC5 F.10
*/

void
rattle (vector3 *pos_old, double dt)
{
  vector3 pos, poso;
  GList *list;
  gint  i;
  gint  maxiter, niter;
  gint  n1, n2;
  static gdouble eps = 1.0e-6;
  gboolean is_done;
  gdouble dist2, delta;
  
  if (is_update == NULL)
    {
      is_update = g_new0 (gboolean, natoms);
      is_moved = g_new0 (gboolean, natoms);
    }
 
  for (i = 0; i < natoms; i++)
    {
      is_moved[i] = TRUE;
      is_update[i] = FALSE;
    }

  maxiter = 100;
  niter   = 0;
  is_done = FALSE;
  
  
  while (!is_done && (niter < maxiter))
    {
      niter++;
      is_done = TRUE;
      
      for (i = 0; i < nrat; i++)
	{
	  n1 = rat[i].ia1;
	  n2 = rat[i].ia2;
	  
	  if (is_moved[n1] || is_moved[n2])
	    {
	      v3_difference (&pos, r[n2], r[n1]);

	      dist2 = pos.x * pos.x + pos.y * pos.y + pos.z * pos.z;
	      delta = rat[i].dist * rat[i].dist - dist2;
	      
	      if (fabs (delta) > eps)
		{
		  double rm1, rm2;
		  double dot;
		  double term;
		  
		  is_done = FALSE;
		  is_update[n1] = TRUE;
		  is_update[n2] = TRUE;
		  
		  v3_difference (&poso, &pos_old[n2], &pos_old[n1]);
		  
		  dot = v3_dot_product (&pos, &poso);

		  rm1 = 1.0/mass[n1];
		  rm2 = 1.0/mass[n2];
		  
		  term = delta / (2.0 * (rm1 + rm2) * dot);
		  
		  v3_scale (&poso, term);
		  
		  r[n1]->x -= poso.x * rm1;
		  r[n1]->y -= poso.y * rm1;
		  r[n1]->z -= poso.z * rm1;
		  
		  r[n2]->x += poso.x * rm2;
		  r[n2]->y += poso.y * rm2;
		  r[n2]->z += poso.z * rm2;
		  
		  rm1 /= dt;
		  rm2 /= dt;
		  
		  vel[n1].x -= poso.x *rm1;
		  vel[n1].y -= poso.y *rm1;
		  vel[n1].z -= poso.z *rm1;
		  
		  vel[n2].x += poso.x *rm2;
		  vel[n2].y += poso.y *rm2;
		  vel[n2].z += poso.z *rm2;
		}
	      
	    }
	}
      

      for (i = 0; i < natoms; i++)
	{
	  is_moved[i] = is_update[i];
	  is_update[i] = FALSE;
	}
      
    }
  

  if (niter == maxiter)
    {
      g_print (" RATTLE -- Warning... Position Constraints \n");
    }
  
}



void
rattle2 (double dt)
{
  int maxiter;
  int niter;
  int i;
  int n1, n2;
  vector3 pos;
  double eps;
  gboolean is_done;
  

  for (i = 0; i < natoms; i++)
    {
      is_moved[i] = FALSE;
      is_update[i] = FALSE;
    }

  
  maxiter = 100;
  niter   = 0;
  is_done = FALSE;
  eps = 0.000001 / dt;
  

  while (!is_done && (niter < maxiter))
    {
      niter++;
      is_done = TRUE;

      for (i = 0; i < nrat; i++)
	{
	  n1 = rat[i].ia1;
	  n2 = rat[i].ia2;
	  
	  if (is_moved[n1] || is_moved[n2])
	    {
	      v3_difference (&pos, r[n1], r[n2]);
	      
	    }
	}
    }
}
