#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "dnd.h"
#include "molecule.h"
#include "dnd-utils.h"


static char buffer[220];

static void crd_read_atoms (FILE *fd, Molecule *mol);
static void crd_read_pos (FILE *fd, Molecule *mol);

#define NOT_USED -1

gboolean
read_crd (Molecule **gmol, char *fname)
{
  FILE *crd_file;
  Molecule *mol;
  
  g_return_val_if_fail (fname != NULL, FALSE);
  g_return_val_if_fail (gmol != NULL, FALSE);
  
  mol = *gmol;
  
  crd_file = fopen (fname, "r");
  
  if (crd_file == NULL)
    {
      g_warning ("Unable to open .crd file %s ", fname);
      return FALSE;
    }
  
  while (dnd_read_line (crd_file, buffer))
    {
      if (dnd_blank_string (buffer))
	continue;
      
      if (buffer[0] == '*')
	continue;
      else
	break;
    }
  
  if (mol == NULL)
    {
      mol = g_new0 (Molecule, 1);
      crd_read_atoms (crd_file, mol); /* to generate psf file */
    }
  else
    crd_read_pos (crd_file, mol);
  
  fclose (crd_file);
  /*
  pos_update (mol);
  */
  *gmol = mol;

  return TRUE;
}


static void
crd_read_atoms (FILE *fd, Molecule *mol)
{
  Segment  *seg;
  Residue  *res;
  AtomInfo     *atom;
  vector3      *pos;
  gint     i;
  gint     natom, natoms, iatom;
  gint     last_natom;
  gint     nres, res_id, ires;
  gint     last_nres;
  GList   *res_list;
  GList   *atom_list;
  GList   *pos_list;
  char  mol_name[10], old_mol_name[10];
  char  res_name[10];
  char  atom_name[10];
  double bfactor;
  double x, y, z;
  

  /* -- Initialize before read atom list --- */
  strcpy (old_mol_name, "     ");
  strcpy (mol_name, "MAIN");
  strcpy (res_name, "     ");
  strcpy (atom_name, "      ");

  last_nres = 0;
  last_natom = 0;
  natom = 0;
  iatom = 0;
  ires  = 0;
  
  res_list = NULL;
  atom_list = NULL;
  pos_list = NULL;

  sscanf (buffer, "%d", &natoms);
  
  for (i = 0; i < natoms; i++)
    {
      if (!dnd_read_line (fd, buffer))
	{
	  g_error ("Fail to read crd file at line %d", i+1);
	  break;
	}

      sscanf (buffer, " %d %d %s %s %lf %lf %lf %s %d %lf",
	      &natom, &nres, res_name, atom_name,
	      &x, &y, &z, mol_name, &res_id, &bfactor);

      /* -- Initiate the new Segment -- */
      if (!str_eq_min (old_mol_name, mol_name))
	{
	  strcpy (old_mol_name, mol_name);
	  seg = g_new0 (Segment, 1);
	  strcpy (seg->name, mol_name);
	  seg->ires = NOT_USED;
	  mol->seg_list = g_list_append (mol->seg_list, seg);
	  last_nres = 0;
	}
	  
      /* --- res_slist, initiate residue --- */
      if (nres != last_nres)
	{
	  if (nres != last_nres+1)
	    {
	      g_message ("Residue Numbers out of order at atom #%d of crd file\n",
			 last_natom+1);
	    }
	  last_nres = nres;
	  ires++;
	  
	  res = g_new0 (Residue, 1);
	  
	  strcpy (res->name, res_name);
	  
	  if (res_list == NULL)
	    {
	      mol->res_list = g_list_append (mol->res_list, res);
	      res_list = mol->res_list;
	    }
	  else
	    {
	      res_list = g_list_append (res_list, res);
	      res_list = res_list->next;
	    }
	  
	  if (seg->ires == NOT_USED)
	    seg->ires = ires - 1;
	  
	}
	  
      /* -- Atom --- */

      if (natom != last_natom+1)
	{
	  g_message ("Atom Numbers out of order at atom #%d of psf file\n",
		     last_natom+1);
	}
      
      last_natom = natom;
      iatom++;
      
      atom = g_new0 (AtomInfo, 1);
      
      strcpy (atom->name, atom_name);
      atom->ires = ires;
      
      if (atom_list == NULL)
	{
	  mol->atom_list = g_list_append (mol->atom_list, atom);
	  atom_list = mol->atom_list;
	}
      else
	{
	  atom_list = g_list_append (atom_list, atom);
	  atom_list = atom_list->next;
	}
      
      if (res->iatom == NOT_USED)
	res->iatom = iatom;
      
      /* --- Pos --- */
      
      pos = g_new0 (vector3, 1);
      
      pos->x = x;
      pos->y = y;
      pos->z = z;
      
      if (pos_list == NULL)
	{
	  mol->pos_list = g_list_append (mol->pos_list, pos);
	  pos_list = mol->pos_list;
	}
      else
	{
	  pos_list = g_list_append (pos_list, pos);
	  pos_list = pos_list->next;
	}
    }
  
}


  
static void
crd_read_pos (FILE *fd, Molecule *mol)
{
  double x, y, z;
  AtomInfo   *atom;
  GList  *atom_list;
  vector3    *pos;
  GList  *pos_list = NULL;
  gint   natoms;
  gint   i;
  
  sscanf (buffer, "%d", &natoms);

  atom_list = mol->atom_list;
  
  for (i = 0; i < natoms; i++)
    {
      if (!dnd_read_line (fd, buffer))
	{
	  g_error ("Fail to read crd file at line %d", i+1);
	  break;
	}
      
      sscanf (buffer, "%*d %*d %*s %*s %lf %lf %lf",
	      &x, &y, &z);
      atom = atom_list->data;
      atom_list = atom_list->next;
	  
      atom->bfactor = 0.0;
      atom->occupancy = 0.0;
      
      pos = g_new0 (vector3, 1);
      
      pos->x = x;
      pos->y = y;
      pos->z = z;
      
      if (pos_list == NULL)
	{
	  mol->pos_list = g_list_append (mol->pos_list, pos);
	  pos_list = mol->pos_list;
	}
      else
	{
	  pos_list = g_list_append (pos_list, pos);
	  pos_list = pos_list->next;
	}
    }
  
}
