#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "dnd.h"
#include "dnd-utils.h"
#include "molecule.h"


static char ATOM[] = "ATOM";
static char HETATM[] = "HETATM";
static char buffer[220];

static void pdb_read_atoms (FILE *fd, Molecule *mol);
static void pdb_read_pos (FILE *fd, Molecule *mol);

#define NOT_USED -1

gboolean
read_pdb (Molecule **gmol, char *fname)
{
  FILE *pdb_file;
  Molecule *mol;
  
  g_return_val_if_fail (fname != NULL, FALSE);
  g_return_val_if_fail (gmol != NULL, FALSE);
  
  mol = *gmol;
  
  pdb_file = fopen (fname, "r");
  
  if (pdb_file == NULL)
    {
      g_warning ("Unable to open .pdb file %s ", fname);
      return FALSE;
    }
  
  while (dnd_read_line (pdb_file, buffer))
    {
      if(dnd_blank_string (buffer))
	continue;
    
      if ((str_eq_min (ATOM, buffer)) ||
	  (str_eq_min (HETATM, buffer)) )
	break;
    }

  if (mol == NULL)
    {
      mol = g_new0 (Molecule, 1);
      pdb_read_atoms (pdb_file, mol); /* to generate psf file */
    }
  else
    pdb_read_pos (pdb_file, mol);
  
  fclose (pdb_file);
  /*
  pos_update (mol);
  */
  *gmol = mol;

  return TRUE;
}


static void
pdb_read_atoms (FILE *fd, Molecule *mol)
{
  Segment  *seg;
  Residue  *res;
  AtomInfo  *atom;
  vector3   *pos;
  gint     natom, iatom;
  gint     last_natom;
  gint     nres, ires;
  gint     last_nres;
  GList   *seg_list;
  GList   *res_list, *start_res_list;
  GList   *atom_list, *start_atom_list;
  GList   *pos_list,  *start_pos_list;
  char  mol_name[10], old_mol_name[10];
  char  res_name[10];
  char  atom_name[10];
  double bfactor, occupancy;
  double x, y, z;
  gint   num, i;
  

  /* -- Initialize before read atom list --- */
  strcpy (old_mol_name, "     ");
  strcpy (mol_name, "MAIN");
  strcpy (res_name, "     ");
  strcpy (atom_name, "      ");

  last_nres = 0;
  last_natom = 0;
  natom = 0;
  iatom = 0;
  ires  = 0;
  seg_list = NULL;
  res_list = NULL;
  atom_list = NULL;
  pos_list = NULL;
    
  while (TRUE)
    {
      if ((str_eq_min (ATOM, buffer)) ||
	  (str_eq_min (HETATM, buffer)) )
	{
	  sscanf (buffer + 30, "%lf %lf %lf %lf %lf ",
		  &x, &y, &z, &occupancy, &bfactor);
	  buffer[30] = '\0';

	  sscanf (buffer, " %*s %d %s %s %d ",
		  &natom, atom_name, res_name, &nres);

	  if ((str_eq_min (res_name, "TIP") || str_eq_min (res_name, "WAT"))
	      && (!str_eq_min (mol_name, "WAT")))
	    {
	      strcpy (mol_name, "WAT");
	    }
	  

	  /* -- Initiate the new Segment -- */
	  if (!str_eq_min (old_mol_name, mol_name))
	    {
	      strcpy (old_mol_name, mol_name);
	      seg = g_new0 (Segment, 1);
	      strcpy (seg->name, mol_name);
	      seg->ires = NOT_USED;
	      seg_list = g_list_append (seg_list, seg);
	      last_nres = 0;
	    }
	  
	  /* --- res_slist, initiate residue --- */
	  if (nres != last_nres)
	    {
	      if (nres != last_nres+1)
		{
		  g_message ("Residue Numbers out of order at atom #%d of pdb file\n",
			     last_natom+1);
		}
	      last_nres = nres;
	      ires++;
	      
	      res = g_new0 (Residue, 1);
	      
	      strcpy (res->name, res_name);
	      
	      if (res_list == NULL)
		{
		  res_list = g_list_append (res_list, res);
		  start_res_list = res_list;
		}
	      else
		{
		  res_list = g_list_append (res_list, res);
		  res_list = res_list->next;
		}

	      if (seg->ires == NOT_USED)
		seg->ires = ires-1;
	      
	    }
	  
	  /* -- Atom --- */

	  if (natom != last_natom+1)
	    {
	      g_message ("Atom Numbers out of order at atom #%d of psf file\n",
			 last_natom+1);
	    }
	  
	  last_natom = natom;
	  iatom++;
	  
	  atom = g_new0 (AtomInfo, 1);

	  strcpy (atom->name, atom_name);
	  atom->ires = ires;
	  
	  if (atom_list == NULL)
	    {
	      atom_list = g_list_append (atom_list, atom);
	      start_atom_list = atom_list;
	    }
	  else
	    {
	       atom_list = g_list_append (atom_list, atom);
	       atom_list = atom_list->next;
	    }
	  
	    if (res->iatom == NOT_USED)
	      res->iatom = iatom;
	  
	  /* --- Pos --- */

	  pos = g_new0 (vector3, 1);
      
	  pos->x = x;
	  pos->y = y;
	  pos->z = z;
	  
	  if (pos_list == NULL)
	    {
	      pos_list = g_list_append (pos_list, pos);
	      start_pos_list = start_pos_list;
	    }
	  else
	    {
	      pos_list = g_list_append (pos_list, pos);
	      pos_list = pos_list->next;
	    }
	  
	}
	 
      if (!dnd_read_line (fd, buffer))
	break;
    }

}


static void
pdb_read_pos (FILE *fd, Molecule *mol)
{
  double x, y, z;
  double bfactor, occupancy;
  AtomInfo   *atom;
  GList      *atom_list;
  GList      *pos_list = NULL;
  vector3    *pos;
  gint       iatom;

  g_return_if_fail (fd != NULL);
  g_return_if_fail (mol != NULL);

  g_print ("In pdb_read_pos \n");
  
  atom_list = mol->atom_list;
    
  iatom = 0;
  
  while (TRUE)
    {
      if ((str_eq_min (ATOM, buffer)) ||
	  (str_eq_min (HETATM, buffer)) )
	{
	  sscanf (buffer + 30, "%lf %lf %lf %lf %lf ",
		  &x, &y, &z, &occupancy, &bfactor);
	  buffer[30] = '\0';
	  /*
	  atom = (AtomInfo *) atom_list->data;
	  
	  atom->bfactor = bfactor;
	  atom->occupancy = occupancy;
	  */
	  pos = g_new0 (vector3, 1);

	  pos->x = x;
	  pos->y = y;
	  pos->z = z;

	  if (pos_list == NULL)
	    {
	      mol->pos_list = g_list_append (mol->pos_list, pos);
	      pos_list = mol->pos_list;
	    }
	  else
	    {
	      pos_list = g_list_append (pos_list, pos);
	      pos_list = pos_list->next;
	    }
	  
	  atom_list = atom_list->next;
	}
      
      if (!dnd_read_line (fd, buffer))
	break;
    }
}

  
