#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "dnd.h"
#include "dnd-utils.h"
#include "molecule.h"

static char buffer [220];
static gint  num_atoms;
static gint  num_bonds;

static void psf_read_atoms (FILE *file, Molecule *mol);
static void psf_read_bonds (FILE *file, Molecule *mol);


gboolean
read_psf (Molecule **gmol, char *fname)
{
  FILE *psf_file;
  gint  num_title;
  gint  i;
  Molecule *mol;
  
  g_return_val_if_fail (fname != NULL, FALSE);
  g_return_val_if_fail (gmol  != NULL, FALSE);
  
  mol = *gmol;
  
  if (mol != NULL)
    {
      g_print (" in mol != NULL \n");
      /*
      return FALSE;
      / * FIXME * /
      molecule_free (&mol);
      */
    }
  else
    mol = g_new0 (Molecule, 1);
  
  psf_file = fopen (fname, "r");
  
  if (psf_file == NULL)
    {
      g_message ("Read_Psf : Unable to open .psf file %s\n", fname);
      return FALSE;
    }
  
  while (dnd_read_line (psf_file, buffer))
    {
      if (dnd_blank_string (buffer))
	continue;
      
      if (!dnd_find_word (buffer, "psf"))
	{
	  g_message ("Unable to find \"PSF\" string in psf file %s\n",
		     fname);
	  return FALSE;
	}
      else
	break;
    }
  
  while (dnd_read_line (psf_file, buffer))
    {
      if (dnd_blank_string (buffer))
	continue;
  
      if (!dnd_find_word (buffer, "ntitle"))
	{
	  g_message ("Unable to find \"NTITLE\" string in psf file %s\n",
		     fname);
	  return FALSE;
	}
      else
	break;
    }

  sscanf (buffer, "%d", &num_title);
  
  i = 0;
  
  while (dnd_read_line (psf_file, buffer) && (i < num_title))
    {
      if (!dnd_blank_string (buffer))
	i++;
    }
  
  while (dnd_read_line (psf_file, buffer))
    {
      if (dnd_blank_string (buffer))
	continue;
      
      if (!dnd_find_word (buffer, "NATOM"))
	{
	 g_message ("Unable to find \"NATOM\" string in psf file %s\n",
		     fname);
	  return FALSE;
	}
      else
	break;
      
    }
 
  sscanf (buffer, "%d", &num_atoms);
   
  psf_read_atoms (psf_file, mol);
  
  /* --- NBOND --- */

  while (dnd_read_line (psf_file, buffer))
    {
      if (dnd_blank_string (buffer))
	continue;
      
      if (!dnd_find_word (buffer, "NBOND"))
	{
	 g_message ("Unable to find \"NBOND\" string in psf file %s\n",
		     fname);
	  return FALSE;
	}
      else
	break;
      
    }
 
  sscanf (buffer, "%d", &num_bonds);
 
  psf_read_bonds (psf_file, mol);

  *gmol = mol;
  
  return TRUE;
}

/*
  <atom#> <mol> <seg#> <res> <atomname> <atomtype> <charge> <mass>
*/

static void
psf_read_atoms (FILE *psf_file, Molecule *mol)
{
  Segment  *seg;
  Residue  *res;
  AtomInfo *atom;
  gint  natom;
  gint  last_natom;
  gint  read_count;
  gint  nres;
  gint  last_nres;
  char  mol_name[10], old_mol_name[10];
  char  res_name[10];
  char  atom_name[10];
  char  atom_type[10];
  double charge, mass;
  GList *res_list  = NULL;
  GList *mol_res_list  = NULL;
  GList *seg_list  = NULL;
  GList *atom_list  = NULL;
  GList *list;
  gint   num_seg, num_res;
  gint   ires, iatom;
  
  /* -- Initialize before read atom list --- */
  strcpy (old_mol_name, "     ");
  strcpy (res_name, "     ");
  strcpy (atom_name, "      ");
  strcpy (atom_type, "      ");
  last_nres = 0;
  last_natom = 0;
  natom = 0;
  ires = 0;
  iatom = 0;
  
  while ((dnd_read_line (psf_file, buffer)) && (natom < num_atoms))
    {
      if (dnd_blank_string (buffer) ||
	  buffer[0] == '!')
	continue;
      
      atom = g_new0 (AtomInfo, 1);
      atom->ires = -1;
      
      read_count = sscanf (buffer, " %d %s %d %s %s %s %lf %lf",
			   &natom, mol_name, &nres, res_name, atom_name,
			   atom_type, &charge, &mass);
      
      if (read_count != 8)
	{
	  g_message ("In PSF file, at line %d \n line = %s \n bad format\n",
		     last_natom+1, buffer);
	  return;
	}
      
      if (!str_eq_min (old_mol_name, mol_name))
	{
	  strcpy (old_mol_name, mol_name);
	  seg = g_new0 (Segment, 1);
	  strcpy (seg->name, mol_name);
	  mol->seg_list = g_list_append (mol->seg_list, seg);
	  seg->ires = -1;
	  /* [FIXME] : atom_slist = NULL */
	  last_nres  = 0;
	}

      /* -- res_slist, initial residue -- */ 
      if (nres != last_nres)
	{
	  if (nres != last_nres+1)
	    {
	      g_message ("Residue Numbers out of order at atom #%d of psf file\n",
		     last_natom+1);
	      return;
	    }

	  last_nres++;
	  ires++;
	  
	  res = g_new0 (Residue, 1);
	  res->iatom = -1;
	  
	  strcpy (res->name, res_name);
	  
	  if (res_list == NULL)
	    {
	      mol->res_list = g_list_append (mol->res_list, res);
	      res_list = mol->res_list;
	    }
	  else
	    {
	      res_list = g_list_append (res_list, res);
	      res_list = res_list->next;
	    }

	  if (seg->ires == -1)
	    seg->ires = ires - 1;
	  
	}
      

      /* --- */
      if (natom != last_natom+1)
	{
	  g_message ("Atom Numbers out of order at atom #%d of psf file\n",
		     last_natom+1);
	  return;
	}
      last_natom++;
      iatom++;
      
      strcpy (atom->name, atom_name);
      strcpy (atom->type, atom_type);
      
      atom->mass = mass;
      atom->charge = charge;

      atom->ires = ires-1;
      
      if (atom_list == NULL)
	{
	  mol->atom_list = g_list_append (mol->atom_list, atom);
	  atom_list = mol->atom_list;
	}
      else 
	{
	  atom_list = g_list_append (atom_list, atom);
	  atom_list = atom_list->next;
	}

      if (res->iatom == -1)
	res->iatom = iatom-1;
      
    }
  
}

    
static void
psf_read_bonds (FILE *psf_file, Molecule *mol)
{
  int  natom[2];
  int  i;
  int  nbond = 0;
  Bond *bond;
  GList *bond_list = NULL;

   g_return_if_fail (psf_file != NULL);
  
  while (nbond < num_bonds)
    {
      for (i = 0; i < 2; i++)
	{
	  natom[i] = dnd_read_int (psf_file) - 1;
	  
	  if (natom[i] >= num_atoms)
	    {
	      g_message ("Bond index %d is higer than max atom number %d\n",
			 natom[i], num_atoms);
	      return ;
	    }
	}

      bond = g_new0 (Bond, 1);
      
      bond->iatom1 = natom[0];
      bond->iatom2 = natom[1];
      
      if (bond_list == NULL)
	{
	  mol->bond_list = g_list_append (mol->bond_list, bond);
	  bond_list = mol->bond_list;
	}
      else
	{
	  bond_list = g_list_append (bond_list, bond);
	  bond_list = bond_list->next;
	}
      
      nbond++;
      
    }
     
}
