#ifndef _DND_RTF_H
#define _DND_RTF_H

#include <glib.h>

enum {
  RTF_NONE,
  RTF_DELETE,
  RTF_ADD,
  RTF_MODIFY
} RTF_MODE;


typedef struct rtf_atom_type  RTF_AtomType;
typedef struct rtf_atom  RTF_Atom;
typedef struct rtf_bond  RTF_Bond;
typedef struct rtf_angle RTF_Angle;
typedef struct rtf_doner RTF_Donor;
typedef struct rtf_acceptor RTF_Acceptor;
typedef struct rtf_ic      RTF_ic;
typedef struct rtf_residue RTF_Residue;

GHashTable *residue_hash;
GHashTable *presidue_hash;
GHashTable *atom_type_hash;


struct rtf_atom_type
{
  char *name;
  int   vdw_type;
  double mass;
};


struct rtf_atom
{
  char *name;
  RTF_AtomType *atom_type;
  double charge;
  int    num_group;
  gint   mode;
};


struct rtf_bond
{
  char *at_name[2];
  gint mode;
};


struct rtf_angle
{
  char *at_name[3];
  gint  mode;
};


struct rtf_donor
{
  char *at_name[2];
  gint  mode;
};


struct rtf_acceptor
{
  char *at_name[2];
  gint  mode;
};


struct rtf_ic
{
  char *at_name[4];
  double  bond[2];
  double  angle[2];
  double  phi;
  gboolean do_chiral;
  gint    mode;
};


struct rtf_residue
{
  char   *name;
  GList  *atom_list;
  GList  *ic_list;
  GList  *bond_list;
  GList  *angle_list;
  GList  *improper_list;
  GList  *dihedral_list;
  GList  *donor_list;
  GList  *acceptor_list;
  GList  *group_list;
  /*  double total_charge; */
};

gboolean read_rtf (char *fname);
RTF_Residue *rtf_get_residue (char *res_name);
RTF_Atom    *rtf_get_atom (RTF_Residue *res, char *atom_name);
gint    get_vdw_type (char *atom_type);

#endif
