#include <glib.h>
#include <math.h>
#include "md.h"

void
sample_gyra (int option)
{
  int i, j, maxx, a;
  static double ggt, gg[500], delta;
  double r2;
  vector3 dr;
  
  maxx = 500;
    
  if (option == 1)
    {
      for (i = 0; i < maxx; i++)
	gg[i] = 0.;
	
      ggt = 0.;
      delta = (maxx-1)/box_2;
    }
  else if (option == 2)
    {
      ggt = ggt + 1.;

      for (i = 0; i < npart - 1; i++)
	{
	  for (j = i+1; j < npart; j++)
	    {
	      dr.x = r[i].x - r[j].x;
	      dr.y = r[i].y - r[j].y;
	      dr.z = r[i].z - r[j].z;
	      
	      if (dr.x > box_2)
		dr.x -= box;
	      else if (dr.x < -box_2)
		dr.x += box;
	      
	      if (dr.y > box_2)
		dr.y -= box;
	      else if (dr.y < -box_2)
		dr.y += box;
	      
	      if (dr.z > box_2)
		dr.z -= box;
	      else if (dr.z < -box_2)
		dr.z += box;

	      r2 = sqrt (dr.x * dr.x + dr.y * dr.y + dr.z * dr.z);
	      
	      if (r2 < box_2)
		{
		  a = ceil(r2 * delta) + 1;
		  gg[a] = gg[a] + 2.0;
		}
	    }
	}
    }
  else
    {
      ggt = 1.0 / (ggt * npart);
      delta = 1.0 /delta;
      
      for (i = 0; i < maxx - 1; i++)
	{
	  r2 = (16. * atan (1.0)/3.0) * ((double)npart/(box * box * box)) *
	    ((i+1)*(i+1)*(i+1) - i * i * i);
	}
    }

}

