#include <stdio.h>
#include <math.h>
#include "vector3.h"

/*
  vel   : velocities of atoms
  dt    : time step size
  temp  : instantaneous temperature
  temp0 : target temperature
*/

void
temper_berendsen (vector3 * vel, double dt, double temp, double temp0)
{
  double scale;
  double tau_temp;
  gint   natoms;
  
  if (temp < 0.1)
    temp = 0.1;

  /* [FIXME] */
  scale = sqrt (1.0 + (dt / tau_temp) * (temp0 / temp - 1.0));
  
  if (scale < 0.8)
    scale = 0.8;
  else if (scale > 1.25)
    scale = 1.25;
  
  natoms = sizeof (vel)/sizeof (vel[0]);
  
  for (i = 0; i < natoms; i++)
    {
      vel[i] = vel[i] * scale;
    }
  
}


/*
  Direct Velocity Scaling Method:
  vel  : velocities of atoms
  temp : instantaneous temperature or system temperature
  temp0 : target temperature
*/

void
temper_direct_velocity (vector3 *vel, double temp, double temp0)
{
  int natoms;
  int i;
  double scale;
  
  scale = sqrt (temp0/temp);
  
  for (i = 0; i < natoms; i++)
    {
      vel[i] = vel[i] * scale;
    }
}


