#include <stdio.h>
#include <math.h>

#define  im  1771875L
#define  ia  2416L
#define  ic  374441L

static double _gauss_rand[100];

static void
_gauss_rand_init ()
{
  int i;
  double x;
  double sum;
  double ex;
  
  sum = 0;
  
  for (i = 0; i < 100; i++)
    {
      x = ((double)i) * 0.01;
      x = x*x;
      ex = exp (-x);
      sum += ex;
      
      _gauss_rand[i] = sum;
    }

  for (i = 0; i < 100; i++)
    {
      _gauss_rand[i] /= sum;
    }
  
}

static unsigned long jran = 1;
void	smdrand(unsigned long seed)
{
   jran = seed;
}

double	mdrand()
{
   jran = (jran*ia + ic) % im;
   return (double)jran/(double)im;
}


static double
gauss_rand1 ()
{
  static int		set = 1;
  static double	gset;
  double		v1, v2, r, fac;
  int i;
  

  if(set)
    {
      do
	{
	  v1 = 2.0*mdrand()-1.0;  
	  v2 = 2.0*mdrand() - 1.0;
	  r = v1*v1 + v2*v2;
	} while(r > 1.0);
    /*
      fac = sqrt(-2.0 * log(r) / r);
      */
    fac = 1.0;
      
      gset = v1 * fac;
      set = 0;
      return(v2*fac);
    }
  else
    {
      set = 1;
      return(gset);
    }
}

static double
gauss_rand ()
{
  double r, v1;
  int i;
  double gset;
  
  r = 2.0 * mdrand () - 1.0;
  
  if (r < 0)
    {
      r = -r;
     
      for (i = 0; i < 100; i++)
	{
	  if (_gauss_rand[i] <= r &&
	      _gauss_rand[i+1] > r)
	    break;
	}
      
      gset = - (0.01) * (double)i;
    }
  else
    {
      for (i = 0; i < 100; i++)
	{
	  if (_gauss_rand[i] <= r &&
	      _gauss_rand[i+1] > r)
	    break;
	}
      
      gset = (0.01) * (double)i;
    }
  
  return gset;
  
  
}



int
main ()
{
  int i;
  double r;
  int m0, m1, m2, m3, m4, m5, m6, m7, m8, m9, m10;
  int p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10;
  
  m0 = m1 = m2 = m3 = m4 = m5 = m6 = m7 = m8 = m9 = m10 =0;
  p0 = p1 = p2 = p3 = p4 = p5 = p6 = p7 = p8 = p9 = p10 =0;

  _gauss_rand_init ();
  
  for (i = 0; i < 10000; i++)
    {
      r = gauss_rand ();

      if (r < -1.0)
	m10++;
      else if (r < -0.9)
	m9++;
      else if (r < -0.8)
	m8++;
      else if (r < -0.7)
	m7++;
      else if (r < -0.6)
	m6++;
      else if (r < -0.5)
	m5++;
      else if (r < -0.4)
	m4++;
      else if (r < -0.3)
	m3++;
      else if (r < -0.2)
	m2++;
      else if (r < -0.1)
	m1++;
      else if (r < 0.0)
	m0++;
      else if (r < 0.1)
	p0++;
      else if (r < 0.2)
	p1++;
      else if (r < 0.3)
	p2++;
      else if (r < 0.4)
	p3++;
      else if (r < 0.5)
	p4++;
      else if (r < 0.6)
	p5++;
      else if (r < 0.7)
	p6++;
      else if (r < 0.8)
	p7++;
      else if (r < 0.9)
	p8++;
      else if (r < 1.0)
	p9++;
      else
	p10++;
      
            
    }
  
  printf ("m8 = %d m7 = %d m6 = %d m5 = %d m4 = %d m3 = %d m2 = %d m1 = %d m0 = %d \n",
	  m8, m7, m6, m5, m4, m3, m2, m1, m0);

  printf ("p8 = %d p7 = %d p6 = %d p5 = %d p4 = %d p3 = %d p2 = %d p1 = %d p0 = %d \n",
	  p8, p7, p6, p5, p4, p3, p2, p1, p0);
  return 1;
  
}
