
void
verlet_velocity (MDData *data)
{
  gint i;
  GList  *pos_list;
  vector3 *pos_old;
  vector3 *vel;
  vector3 *acc;
  gdouble dt, dt2, dt2_2;
  
  pos_old = data->force_info->pos_old;
  vel     = data->force_info->vel;
  acc     = data->force_info->acc;
  
  dt = data->control->dt;
  dt_2 = 0.5 * dt;
  dt2_2 = dt_2 * dt;
  
  for (i = 0, pos_list = data->mol->pos_list; pos_list;
       i++, pos_list = pos_list->next)
    {
      Pos *pos = pos_list->data;
      
      v3_eq (&pos_old[i], pos);

      pos->x += (vel[i].x * dt + acc[i].x *dt2_2);
      pos->y += (vel[i].y * dt + acc[i].y *dt2_2);
      pos->z += (vel[i].z * dt + acc[i].z *dt2_2);
      
      vel[i].x += dt_2 * acc[i].x;
      vel[i].y += dt_2 * acc[i].y;
      vel[i].z += dt_2 * acc[i].z;
    }
  
  if (data->control->do_rattle)
    {
      rattle (data->pos_list, pos_old, dt);
    }
  
  force_calc (data);
  
  /* update velocities and accelerations */
  
  for (i = 0, atom_list = data->mol->atom_list; atom_list;
       i++, atom_list = atom_list->next)
    {
      Atom *atom = atom_list->data;
      double mass = atom->mass;
      /* [FIXME] : unit change */
      acc[i].x = -force[i].x / mass;
      acc[i].y = -force[i].y / mass;
      acc[i].z = -force[i].z / mass;
      
      vec[i].x += dt_2 * acc[i].x;
      vec[i].y += dt_2 * acc[i].y;
      vec[i].z += dt_2 * acc[i].z;
    }
  
      
}


void
verlet_leapfrog (MDData *data)
{
  vector3 *vel;
  GList  *atom_list;
  GList  *pos_list;
  gint   i;
  gdouble dt;
  
  g_return_fail_if_fail (data != NULL);
  g_return_fail_if_fail (data->control);
  g_return_fail_if_fail (data->force_info);
  
  dt = data->control->dt;
  vel = data->force_info->vel;
  acc = data->force_info->acc;
  force = data->force_info->force;
  

  /* Move */
  for (pos_list = data->mol->pos_list, atom_list = data->mol->atom_list, i = 0;
       pos_list;
       pos_list = pos_list->next, atom_list = atom_list->next, i++)
    {
      Atom *atom = atom_list->data;
      Pos  *pos = pos_list->data;
      vector3 acc_dt;
      vector3 vel_dt;
      
      vel[i].x += (dt * acc[i].x);
      vel[i].y += (dt * acc[i].y);
      vel[i].z += (dt * acc[i].z);
      
      pos->x += (dt * vel[i].x);
      pos->y += (dt * vel[i].y);
      pos->z += (dt * vel[i].z);
    }

  if (data->control->do_rattle)
    {
      rattle ();
    }
  
  force_calc (data);
  
  for (i = 0, atom_list = data->mol->atom_list; atom_list;
       i++, atom_list = atom_list->next)
    {
      Atom *atom = atom_list->data;
      double mass = atom->mass;
      /* [FIXME] : unit change */
      acc[i].x = -force[i].x / mass;
      acc[i].y = -force[i].y / mass;
      acc[i].z = -force[i].z / mass;
    }
  
}
