function [new_network, blocked] = correctReversibilities (solver, network)
% Correct the reversibilities and inconsistencies of the network.
%
% Input arguments: 
%   solver
%   network
% Output arguments:
%   new_network
%   blocked

%    tic
LPsolver = solver;
s = size(network.stoichiometricMatrix);
v = zeros(length(network.reversibilityVector),1);

for i = 1:s(2)
    % s = size(network.stoichiometricMatrix);
    %percent_completed=round((i/s(2))*100);
    %display(percent_completed)

    % setting upper and lower bounds for LPs
    Ub = Inf (s(2),1);
    Ub(i) = 1;
    Lb = -Inf (s(2),1);
    Lb(logical(~network.reversibilityVector),:)=0;
    Lb(i)= 1;


    status1 = feasibleLP(LPsolver, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);

    Ub(i)=-1;
    Lb(i)=-1;

    status2 = feasibleLP(LPsolver, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);

    if (strcmp ('infeasible', status1) && strcmp ('infeasible', status2))
        %it's blocked
        v(i)= 1;
    elseif (strcmp ('infeasible', status1) && strcmp ('feasible', status2))
        %reaction is irreversible 
        v(i) = 2;
    elseif (strcmp ('feasible', status1) && strcmp ('infeasible', status2))
        %reaction is irreversible 
        v(i) = 3;
    elseif (strcmp ('feasible', status1) && strcmp ('feasible', status2))
        %reaction is reversible 
        v(i) = 4;
    else
        warning ('correction failed')
    end
    

    
end

blocked = sort([find(v==1); find((v==2)&(~network.reversibilityVector))]);

oldrevvec = network.reversibilityVector;
%for v=2 reaction is irreversible --> set value in reversibility vector to 0
%and multiply column in matrix by -1
%this should only be happening when reaction is claimed to be reversible,
%not if its irreversible in the other direction! In this case the reaction
%is blocked and you need to delete it later on
w=(v==2)&network.reversibilityVector;
network.stoichiometricMatrix(:,w)=-network.stoichiometricMatrix(:,w);
network.reversibilityVector(w)=0;

%for v=3 reaction is irreversible --> set value in reversibility vector to 0
network.reversibilityVector(v==3)=0;

%for v =4 reaction is reversible --> if reaction is claimed to be reversible
%leave value in reversibility vector at 1
%if reaction is not claimed to be reversible but could be leave it at 0
%so: don't do anything
%network.reversibilityVector(v==4)=1;  

%for v=1 it's blocked--> delete reaction from matrix + names + reversibility
%vector
%also delete reactions from above (v==2, but irreversible)
w=(v==2)&~oldrevvec;
x=w|(v==1);
% dlmwrite('blocked_reactions.txt', network.Reactions(x, :), 'delimiter', '');
network.stoichiometricMatrix(:,x)=[];
new_network.Reactions = network.Reactions(~x, :);
network.reversibilityVector(x)=[];        

%metabolites update --> delete empty rows and corresponding names    
z=~any(network.stoichiometricMatrix,2);
network.stoichiometricMatrix(z,:)=[];
network.Metabolites(z,:)= [];

% define output of function
%new_network.v = v;
new_network.stoichiometricMatrix = network.stoichiometricMatrix;
new_network.reversibilityVector = logical(network.reversibilityVector);
%new_network.Reactions = network.Reactions;
new_network.Metabolites = network.Metabolites;
