function couplingtype = pairwiseCouplingBwoS (solver, network, ri, rj)

% It computes the couplingtype of two given Reactions 
% input arguments:
    % solver: specifies the solver that should be used (possible values:'linprog', 'clp', 'lindo', 'glpk')
    % network: network that you want to analyze
    % ri: number of first reaction to be considered
    % rj: number of second reaction to be considered
% output arguments:
    % couplingtype: is a number symbolizing the coupling type of the two
    % reactions
            % The numbers mean the following:
            % 1 - fully coupled
            % 2 - partially coupled
            % 3 - i is directionally coupled to j
            % 4 - j is directionally coupled to i
            % 5 - uncoupled
 % In the classical approach two LP's are considered (for two irreversible reactions)
 % The following combinations of min/max-values are possible:
    
 %this is for fixed i and varying j
    % 1. (-inf, -a) -> d ---- should not appear --- but it does!
    % 2. (-inf, 0) -> U ---- should not appear
    % 3. (-inf, a) -> U
    % 4. (-inf, inf) -> U
    % 5. (-a, -a) -> F
    % 6. (-a, -b) -> P ---- should not appear
    % 7. (-a, 0) -> D ---- should not appear
    % 8. (-a b) -> U
    % 9. (-a, inf) -> U
    % 10. (0, a) -> D 
    % 11. (0, inf) -> U
    % 12. (a, a) ->F
    % 13. (a, b) -> P
    % 14. (a, inf) -> d 
    


eps = 10e-6;
LPsolver=solver; 
s=size(network.stoichiometricMatrix);
        
if (network.reversibilityVector(ri)==0)&&(network.reversibilityVector(rj)==0)     

        Ub = Inf (s(2),1);
        Ub(rj) = 1;
        Lb = -Inf (s(2),1);
        Lb(logical(~network.reversibilityVector),:)=0;
        Lb(rj)= 1;
        c=zeros(1,s(2));
        c(ri)=1;
        c=c';

        [status1, opt1, xopt1] = solveLP(LPsolver, 'min', c, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);

        opt1 = round(opt1*1000000)/1000000;

        [status2, opt2, xopt2] = solveLP(LPsolver, 'max', c, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);
 
        opt2 = round(opt2*1000000)/1000000;

        if strcmp(status1, '?')||strcmp(status2,'?')   
            couplingtype = 7;
            warning ('couldnt compute couplingtype due to problem with LPsolver')
        elseif strcmp (status1, 'optimal') && strcmp (status2, 'optimal') && (abs(opt1-opt2)<=eps)
            couplingtype = 1; %reactions are fully coupled
        elseif strcmp (status1, 'optimal') && strcmp (status2, 'optimal') && (abs(opt1-opt2)>eps)&& (abs(opt1)>eps)&&(abs(opt2)>eps)
            couplingtype = 2; %reactions are partially coupled
        elseif (strcmp (status1, 'optimal') && (opt1==0) && strcmp (status2, 'optimal')&& (opt2>0))
            couplingtype = 3; %reactions are directionally coupled, ri --> rj
        elseif (strcmp (status1, 'optimal') && (opt1>0)&& strcmp (status2, 'unbounded'))
            couplingtype = 4; %reactinos are directionally coupled, rj --> ri      
        elseif (strcmp (status1, 'unbounded') && strcmp (status2, 'optimal') && (opt2>=0) )||(strcmp (status1, 'unbounded') && strcmp (status2, 'unbounded')  )||(strcmp (status1, 'optimal')&&(opt1<0) && strcmp (status2, 'optimal') && (opt2>0) )||(strcmp (status1, 'optimal')&&(opt1<=0) && strcmp (status2, 'unbounded')  )
            couplingtype = 5; %reactions are uncoupled    
        else 
            couplingtype = 6 ;
            warning('combination of min/max-values should not appear if preprocessing worked correctly')%what happens now?
        end
        
elseif (network.reversibilityVector(ri)==1)&&(network.reversibilityVector(rj)==0)
        
        Ub = Inf (s(2),1);
        Ub(rj) = 1;
        Lb = -Inf (s(2),1);
        Lb(logical(~network.reversibilityVector),:)=0;
        Lb(rj)= 1;
        c=zeros(1,s(2));
        c(ri)=1;
        c=c';

        [status1, opt1, xopt1] = solveLP(LPsolver, 'min', c, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);

        opt1 = round(opt1*1000)/1000;

        [status2, opt2, xopt2] = solveLP(LPsolver, 'max', c, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);
 
        opt2 = round(opt2*1000)/1000;

        if strcmp(status1, '?')||strcmp(status2,'?')   
            couplingtype = 7;
            warning ('couldnt compute couplingtype due to problem with LPsolver')  
        elseif strcmp (status1, 'optimal') && strcmp (status2, 'optimal') && (opt1==opt2)
            couplingtype = 1; %reactions are fully coupled
        elseif strcmp (status1, 'optimal') && strcmp (status2, 'optimal') && (opt1 ~= opt2)&& (opt1~=0)&&(opt2~=0)&& ((opt1<=0 && opt2<=0)||(opt1>=0 && opt2>=0))
            couplingtype = 2; %reactions are partially coupled
        elseif (strcmp (status1, 'optimal') && (opt1==0) && strcmp (status2, 'optimal')&& (opt2>0)) || (strcmp(status1, 'optimal')&&(opt1<0)&&(strcmp(status2, 'optimal')&&(opt2==0)))||(strcmp (status1, 'optimal')&&(opt1<0) && strcmp (status2, 'optimal') && (opt2>0) )
            couplingtype = 3; %reactions are directionally coupled, ri --> rj
        elseif (strcmp (status1, 'optimal') && (opt1>0)&& strcmp (status2, 'unbounded'))||(strcmp(status1, 'unbounded')&& strcmp(status2, 'optimal')&&(opt2<0))
            couplingtype = 4; %reactinos are directionally coupled, rj --> ri      
        elseif (strcmp (status1, 'unbounded') && strcmp (status2, 'optimal') && (opt2>=0) )||(strcmp (status1, 'unbounded') && strcmp (status2, 'unbounded')  )||(strcmp (status1, 'optimal')&&(opt1<=0) && strcmp (status2, 'unbounded')  )
            couplingtype = 5; %reactions are uncoupled    
        else 
            couplingtype = 6 ;
            warning('combination of min/max-values should not appear if preprocessing worked correctly')%what happens now?
        end

        
elseif (network.reversibilityVector(ri)==0)&&(network.reversibilityVector(rj)==1)
        Ub = Inf (s(2),1);
        Ub(ri) = 1;
        Lb = -Inf (s(2),1);
        Lb(logical(~network.reversibilityVector),:)=0;
        Lb(ri)= 1;
        c=zeros(1,s(2));
        c(rj)=1;
        c=c';

        [status1, opt1, xopt1] = solveLP(LPsolver, 'min', c, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);

        opt1 = round(opt1*1000)/1000;

        [status2, opt2, xopt2] = solveLP(LPsolver, 'max', c, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);
 
        opt2 = round(opt2*1000)/1000;

        if strcmp(status1, '?')||strcmp(status2,'?')   
            couplingtype = 7;
            warning ('couldnt compute couplingtype due to problem with LPsolver')            
        elseif strcmp (status1, 'optimal') && strcmp (status2, 'optimal') && (opt1==opt2)
            couplingtype = 1; %reactions are fully coupled
        elseif strcmp (status1, 'optimal') && strcmp (status2, 'optimal') && (opt1 ~= opt2)&& (opt1~=0)&&(opt2~=0)&& ((opt1<=0 && opt2<=0)||(opt1>=0 && opt2>=0))
            couplingtype = 2; %reactions are partially coupled
        elseif(strcmp (status1, 'optimal') && (opt1>0)&& strcmp (status2, 'unbounded'))||(strcmp(status1, 'unbounded')&& strcmp(status2, 'optimal')&&(opt2<0))||(strcmp (status1, 'optimal')&&(opt1<0) && strcmp (status2, 'optimal') && (opt2>0) )
            couplingtype = 4; %reactions are directionally coupled, rj --> ri
        elseif (strcmp (status1, 'optimal') && (opt1==0) && strcmp (status2, 'optimal')&& (opt2>0)) || (strcmp(status1, 'optimal')&&(opt1<0)&&(strcmp(status2, 'optimal')&&(opt2==0)))
            couplingtype = 3; %reactions are directionally coupled, ri --> rj      
        elseif (strcmp (status1, 'unbounded') && strcmp (status2, 'optimal') && (opt2>=0) )||(strcmp (status1, 'unbounded') && strcmp (status2, 'unbounded')  )||(strcmp (status1, 'optimal')&&(opt1<0) && strcmp (status2, 'optimal') && (opt2>0) )||(strcmp (status1, 'optimal')&&(opt1<=0) && strcmp (status2, 'unbounded')  )
            couplingtype = 5; %reactions are uncoupled    
        else 
            couplingtype = 6 ;
            warning('combination of min/max-values should not appear if preprocessing worked correctly')%what happens now?
        end

       
elseif (network.reversibilityVector(ri)==1)&&(network.reversibilityVector(rj)==1)
        Ub = Inf (s(2),1);
        Ub(ri) = 1;
        Lb = -Inf (s(2),1);
        Lb(logical(~network.reversibilityVector),:)=0;
        Lb(ri)= 1;
        c=zeros(1,s(2));
        c(rj)=1;
        c=c';

        [status1, opt1, xopt1] = solveLP(LPsolver, 'min', c, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);

        opt1 = round(opt1*1000)/1000;

        [status2, opt2, xopt2] = solveLP(LPsolver, 'max', c, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);
 
        opt2 = round(opt2*1000)/1000;

        if strcmp(status1, '?')||strcmp(status2,'?')   
            couplingtype1 = 7;
            warning ('couldnt compute couplingtype due to problem with LPsolver')             
        elseif strcmp (status1, 'optimal') && strcmp (status2, 'optimal') && (opt1==opt2)
            couplingtype1 = 1; %reactions are fully coupled
        elseif strcmp (status1, 'optimal') && strcmp (status2, 'optimal') && (opt1 ~= opt2)&& (opt1~=0)&&(opt2~=0)&& ((opt1<=0 && opt2<=0)||(opt1>=0 && opt2>=0))
            couplingtype1 = 2; %reactions are partially coupled
        elseif (strcmp (status1, 'optimal') && (opt1==0) && strcmp (status2, 'optimal')&& (opt2>0)) || (strcmp(status1, 'optimal')&&(opt1<0)&&(strcmp(status2, 'optimal')&&(opt2==0)))||(strcmp (status1, 'optimal')&&(opt1<0) && strcmp (status2, 'optimal') && (opt2>0) )
            couplingtype1 = 3; %reactions are directionally coupled, ri --> rj
        elseif (strcmp (status1, 'optimal') && (opt1>0)&& strcmp (status2, 'unbounded'))||(strcmp(status1, 'unbounded')&& strcmp(status2, 'optimal')&&(opt2<0))
            couplingtype1 = 4; %reactinos are directionally coupled, rj --> ri      
        elseif (strcmp (status1, 'unbounded') && strcmp (status2, 'optimal') && (opt2>=0) )||(strcmp (status1, 'unbounded') && strcmp (status2, 'unbounded')  )||(strcmp (status1, 'optimal')&&(opt1<0) && strcmp (status2, 'optimal') && (opt2>0) )||(strcmp (status1, 'optimal')&&(opt1<=0) && strcmp (status2, 'unbounded')  )
            couplingtype1 = 5; %reactions are uncoupled    
        else 
            couplingtype1 = 6 ;
            warning('combination of min/max-values should not appear if preprocessing worked correctly')%what happens now?
            display(status1)
            display(status2)
        end
    
        Ub(ri) = -1;
        Lb(ri)= -1;
       
        [status1, opt1, xopt1] = solveLP(LPsolver, 'min', c, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);

        opt1 = round(opt1*1000)/1000;

        [status2, opt2, xopt2] = solveLP(LPsolver, 'max', c, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);
 
        opt2 = round(opt2*1000)/1000;

        if strcmp(status1, '?')||strcmp(status2,'?')   
            couplingtype2 = 7;
            warning ('couldnt compute couplingtype due to problem with LPsolver')             
        elseif strcmp (status1, 'optimal') && strcmp (status2, 'optimal') && (opt1==opt2)
            couplingtype2 = 1; %reactions are fully coupled
        elseif strcmp (status1, 'optimal') && strcmp (status2, 'optimal') && (opt1 ~= opt2)&& (opt1~=0)&&(opt2~=0)&& ((opt1<=0 && opt2<=0)||(opt1>=0 && opt2>=0))
            couplingtype2 = 2; %reactions are partially coupled
        elseif (strcmp (status1, 'optimal') && (opt1==0) && strcmp (status2, 'optimal')&& (opt2>0))|| (strcmp(status1, 'optimal')&&(opt1<0)&&(strcmp(status2, 'optimal')&&(opt2==0)))||(strcmp (status1, 'optimal')&&(opt1<0) && strcmp (status2, 'optimal') && (opt2>0) )
            couplingtype2 = 3; %reactions are directionally coupled, ri --> rj
        elseif (strcmp (status1, 'optimal') && (opt1>0)&& strcmp (status2, 'unbounded'))||(strcmp(status1, 'unbounded')&& strcmp(status2, 'optimal')&&(opt2<0))
            couplingtype2 = 4; %reactions are directionally coupled, rj --> ri      
        elseif (strcmp (status1, 'unbounded') && strcmp (status2, 'optimal') && (opt2>=0) )||(strcmp (status1, 'unbounded') && strcmp (status2, 'unbounded')  )||(strcmp (status1, 'optimal')&&(opt1<0) && strcmp (status2, 'optimal') && (opt2>0) )||(strcmp (status1, 'optimal')&&(opt1<=0) && strcmp (status2, 'unbounded')  )
            couplingtype2 = 5; %reactions are uncoupled    
        else 
            couplingtype2 = 6 ;
            warning('combination of min/max-values should not appear if preprocessing worked correctly')%what happens now?

        end


        if (couplingtype1==7)||(couplingtype2==7)
            couplingtype = 7;
            warning ('couldnt compute couplingtype due to problem with LPsolver')  
        elseif (couplingtype1 == 1)&& (couplingtype2 == 1)
            couplingtype = 1;%fully coupled
        elseif (couplingtype1==2)&&((couplingtype2==1) ||(couplingtype2 == 2))||(couplingtype2==2)&&((couplingtype1==1) ||(couplingtype1 == 2))
            couplingtype = 2;%partially coupled
        elseif ((couplingtype1==3)&&((couplingtype2==1)||(couplingtype2==2)||(couplingtype2==3)))||((couplingtype2==3)&&((couplingtype1==1)||(couplingtype1==2)||(couplingtype1==3)))
            couplingtype = 3; %D directionally coupled vi to vj
        elseif ((couplingtype1==4)&&((couplingtype2==1)||(couplingtype2==2)||(couplingtype2==4)))||((couplingtype2==4)&&((couplingtype1==1)||(couplingtype1==2)||(couplingtype1==4)))
            couplingtype = 4; %d directionally coupled vj to vi
        elseif (couplingtype1 == 5) || (couplingtype2==5)||((couplingtype1==3)&&(couplingtype2==4))||((couplingtype1==4)&&(couplingtype2==3))
            couplingtype = 5; %uncoupled
        else
            couplingtype = 6;
            warning('combination of couplingtypes is weird')%what happens now?
        end
        
        
end
      