function couplingtype = pairwiseCouplingFFCA(solver,network, ri, rj, Irev, Prev, Frev)
% This function uses the Feasibility-based Approach to Flux Coupling Analysis.
% It computes the couplingtype of two given Reactions 
% input arguments:
    % solver: specifies the solver that should be used (possible values:'linprog', 'clp', 'lindo', 'glpk')
    % network: network that you want to analyze
    % ri: number of first reaction to be considered
    % rj: number of second reaction to be considered
    % Irev: binary vector for irreversible reactions
    % Prev: binary vector for pseudo-irreversible reactions
    % Frev: binary vector for fully reversible reactions
% output arguments:
    % couplingtype: is a number symbolizing the coupling type of the two
    % reactions
            % The numbers mean the following:
            % 1 - fully coupled
            % 2 - partially coupled
            % 3 - i is directionally coupled to j
            % 4 - j is directionally coupled to i
            % 5 - uncoupled

LPsolver = solver;
      s=size(network.stoichiometricMatrix);
 if ri==rj
     couplingtype=1;
 elseif (Irev(ri)==1)&&(Irev(rj)==1)     

        %P1 for vi = 1 and vj=0
        Ub = Inf (s(2),1);
        Ub(rj) = 0;
        Ub(ri) = 1;
        
       
        Lb = -Inf (s(2),1);
        Lb(logical(~network.reversibilityVector),:)=0;
        Lb(rj)= 0;
        Lb(ri)= 1;
        

        status1 = feasibleLP(LPsolver, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);
        
        %P2 for vi = 0 and vj = 1 
        Ub(ri) = 0;
        Ub(rj) = 1;       
        Lb(ri)= 0;
        Lb(rj)= 1;
        
        status2 = feasibleLP(LPsolver, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);


        if strcmp(status1, '?')||strcmp(status2,'?')   
            couplingtype = 7;
            warning ('couldnt compute couplingtype due to problem with LPsolver')           
        elseif (strcmp (status1, 'infeasible') && strcmp (status2, 'feasible'))
            couplingtype = 3; %reactions are directionally coupled, ri --> rj 
        elseif (strcmp (status1, 'feasible') && strcmp (status2, 'infeasible') )
            couplingtype = 4; %reactions are directionally coupled, rj --> ri   
        elseif (strcmp (status1, 'feasible') && strcmp (status2, 'feasible'))
            couplingtype = 5; %reactions are uncoupled    
        elseif (strcmp (status1, 'infeasible') && strcmp (status2, 'infeasible'))
            couplingtype = 8; %neues zeichen f�r partial oder full coupling
%             couplingtype = pairwiseCoupling (LPsolver, network, ri, rj);
%             if ((couplingtype ==3) || (couplingtype ==4) ||(couplingtype ==5)||(couplingtype ==6)  )
%                 warning('classical and feasibility-based approach dont match...')
%             end
        else 
            couplingtype = 6 ;
            warning('not possible...')
        end
  elseif (Prev(ri)==1)&&(Irev(rj)==1)
        
        %P1 for vi = 1 and vj=0
        Ub = Inf (s(2),1);
        Ub(ri) = 1;
        Ub(rj) = 0;
       
        Lb = -Inf (s(2),1);
        Lb(logical(~network.reversibilityVector),:)=0;
        Lb(ri)= 1;
        Lb(rj)= 0;

        status1 = feasibleLP(LPsolver, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);
        
        %P2 for vi = -1 and vj=0
        
        Ub(ri) = -1;
        Ub(rj) = 0;
        Lb(ri)= -1;
        Lb(rj)= 0;
        
        status2 = feasibleLP(LPsolver, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);


        if strcmp(status1, '?')||strcmp(status2,'?')  
            couplingtype = 7;
            warning ('couldnt compute couplingtype due to problem with LPsolver')           
        elseif (strcmp (status1, 'infeasible') && strcmp (status2, 'infeasible'))
            couplingtype = 3; %reactions are directionally coupled, ri --> rj 
        else 
            couplingtype =5 ;
        end

  elseif (Irev(ri)==1)&&(Prev(rj)==1)
    
        %P1 for vi = 0 and vj = 1 
        Ub = Inf (s(2),1);
        Ub(ri) = 0;
        Ub(rj) = 1;  
        Lb = -Inf (s(2),1);
        Lb(logical(~network.reversibilityVector),:)=0;
        Lb(ri)= 0;
        Lb(rj)= 1;
        
        status1 = feasibleLP(LPsolver, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);
        
        %P2 for vi = 0 and vj=-1
        Ub(ri) = 0;
        Ub(rj) = -1;
        Lb(ri)= 0;
        Lb(rj)= -1;
        
        status2 = feasibleLP(LPsolver, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);

        if strcmp(status1, '?')||strcmp(status2,'?')
            couplingtype = 7;
            warning ('couldnt compute couplingtype due to problem with LPsolver')           
        elseif (strcmp (status1, 'infeasible') && strcmp (status2, 'infeasible'))
            couplingtype = 4; %reactions are directionally coupled, rj --> ri   
        else 
            couplingtype = 5 ;
        end
  elseif (Prev(ri)==1)&&(Prev(rj)==1)
        %P1 for vi = 1 and vj=0
        Ub = Inf (s(2),1);
        Ub(ri) = 1;
        Ub(rj) = 0;
       
        Lb = -Inf (s(2),1);
%        Lb(logical(~network.reversibilityVector),:)=0;
        Lb(ri)= 1;
        Lb(rj)= 0;

        status1 = feasibleLP(LPsolver, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);
        
        if strcmp(status1, '?')
            couplingtype = 7;
            warning ('couldnt compute couplingtype due to problem with LPsolver')                    
        elseif strcmp(status1, 'infeasible')
            couplingtype = 1; 
        else 
            couplingtype = 5;
        end

        %P2 for vi = -1 and vj=0
%        Ub(ri) = -1;
%        Ub(rj) = 0;
%        Lb(ri)= -1;
%        Lb(rj)= 0;
%        
%        status2 = feasibleLP(LPsolver, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);
%        
%        if strcmp(status1, '?')||strcmp(status2,'?')
%            couplingtype = 7;
%            warning ('couldnt compute couplingtype due to problem with LPsolver')              
%        
%    
%        elseif (strcmp (status1, 'infeasible') && strcmp (status2, 'infeasible'))
%            couplingtype = 1; 
%        else 
%            couplingtype = 5;
%        end
 elseif (Frev(ri)==1)&&(Frev(rj)==1)
        %P1 for vi = 1 and vj=0
        Ub = Inf (s(2),1);
        Ub(ri) = 1;
        Ub(rj) = 0;
       
        Lb = -Inf (s(2),1);
%        Lb(logical(~network.reversibilityVector),:)=0;
        Lb(ri)= 1;
        Lb(rj)= 0;

        status1 = feasibleLP(LPsolver, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);
        
        if strcmp(status1, '?')
            couplingtype = 7;
            warning ('couldnt compute couplingtype due to problem with LPsolver')                    
        elseif strcmp(status1, 'infeasible')
            couplingtype = 1; 
        else 
            couplingtype = 5;
        end
        
        %P2 for vi = -1 and vj=0
%        Ub(ri) = -1;
%        Ub(rj) = 0;
%        Lb(ri)= -1;
%        Lb(rj)= 0;
%        
%        status2 = feasibleLP(LPsolver, network.stoichiometricMatrix, zeros(s(1),1), [], [], Lb, Ub);
%        
%        if strcmp(status1, '?')||strcmp(status2,'?')
%            couplingtype = 7;
%            warning ('couldnt compute couplingtype due to problem with LPsolver')              
%        
%    
%        elseif (strcmp (status1, 'infeasible')&& strcmp (status2, 'infeasible'))
%            couplingtype = 1; 
%        else 
%            couplingtype = 5;
%        end
               
  else couplingtype=5;
  end       
 