function [Irev,Prev,Frev]=reaction_classificationFB(network)
% input arguments:
    % network: network that you want to analyze
% output arguments:
    % Irev: binary vector for irreversible reactions
    % Prev: binary vector for pseudo-irreversible reactions
    % Frev: binary vector for fully reversible reactions
    
 n = size(network.stoichiometricMatrix);

submatrix= network.stoichiometricMatrix;

submatrix(:,~network.reversibilityVector)=[];

ls= null(submatrix, 'r'); 
if isempty(ls)
    ls = zeros (1, n(2));
else
    ls=ls';
end

dimls=size(ls);

Frevtemp=zeros(dimls(2),1);
for i = 1:dimls(2)
    if sum(ls(:,i)~=zeros(dimls(1),1))~=0
        Frevtemp(i)=1;              
    end
end


Irev = zeros (length(network.reversibilityVector),1);
Prev = zeros (length(network.reversibilityVector),1);
Frev = zeros (length(network.reversibilityVector),1);
count=0;
for i = 1: length(network.reversibilityVector)
    if network.reversibilityVector(i)==1 
        count=count+1;
        if Frevtemp(count)==1
            Frev(i)=1;
        else
            Prev(i)=1;
        end
    else Irev(i)=1;
    end
end