#!/usr/bin/python
# 0.41   24-Jul-2003
"""
__version__ = "$Revision: 1.6 $"
__date__ = "$Date: 2002/07/29 17:44:55 $"
"""

from PythonCardPrototype import model
import webbrowser
from Bio.Blast import NCBIStandalone



#some variables.
blastexe="c:\\bioinfo-adv\\blast\\blastall.exe"
pathdb="c:\\bioinfo-adv\\blast\\data\\" # aca hay que agregar cada base en part.
tempdir="c:\\bioinfo-adv\\temp\\"
outformat='T'

class WinBlast(model.Background):

    def on_menuFileExit_select(self, event):
        self.Close()
    def on_incrBtn_mouseClick(self, event):
        startValue = int(self.components.field1.text)
        endValue = startValue + 1
        self.components.field1.text = str(endValue)
    def on_decrBtn_mouseClick(self, event):
        startValue = int(self.components.field1.text)
        endValue = startValue - 1
        self.components.field1.text = str(endValue)
    def on_resetBtn_mouseClick(self, event):
        self.components.field1.text = "0"

    def on_SliderWordSize_mouseClick(self, event):
        pass
    def on_ComboProgram_selected(self, event):
        pass

    def getradiooutput(self):
        if self.components.radiooutput.selected=="Html":
            return "T"
        elif self.components.radiooutput.selected=="Plain text":
            return "F"
    #radiobuttons. T = HTML and F = TXT

#def getInputActionMode(self):
#        """Returns the type of action the next text input should do."""
#        if self.components.nextInputActionMode.selected == "inserts":
#            return "insert"
#        elif self.components.nextInputActionMode.selected == "appends":
#            return "append"
#        elif self.components.nextInputActionMode.selected == "replaces":
#            return "replace"

           
    def on_Btnrunblast_mouseClick(self, event):
        if self.components.ComboDB.text=='nr':
            base='nr'
        elif self.components.ComboDB.text=='Arabidopsis Thaliana':
            base='atal.faa'
        elif self.components.ComboDB.text=='E.Coli':
            if (self.components.ComboProgram.text==('blastp'))|(self.components.ComboProgram.text==('blastx')):
                base='ecoli.aa'
            else:
                base='ecoli.nt'

        else:
            base='nr.aa'  # warning about this.
        print "BLAST: "
        print self.components.ComboProgram.text
        print pathdb+base
        print self.components.seqinput.text
        archentrada=open(tempdir+"input.txt",'w')
        archentrada.writelines(self.components.seqinput.text)
        archentrada.close()
        texto = self.getradiooutput()  # radiobuttons
        blast_out, error_info = NCBIStandalone.blastall(blastexe, self.components.ComboProgram.text, pathdb+base, tempdir+'input.txt', expectation=5, html=texto)
        if texto=="T":
            f=open(tempdir+"tempblast.htm", 'w')
            # T = HTML
        else:
            f=open(tempdir+"tempblast.txt", 'w')
        f.writelines(blast_out)
        f.close()
        if texto=="T":
            webbrowser.open(tempdir+"tempblast.htm")
        else:
            webbrowser.open(tempdir+"tempblast.txt")
        # this option should be available only something on the text box. 
        

if __name__ == '__main__':
    app = model.PythonCardApp(WinBlast)
    app.MainLoop()
