

=head2 AUTHORS

Mark Wilkinson (mwilkinson@gene.pbi.nrc.ca)
Plant Biotechnology Institute, National Research Council of Canada.
Copyright (c) National Research Council of Canada, October, 2000.

=head2 DISCLAIMER

Anyone who intends to use and uses this software and code acknowledges and
agrees to the following: The National Research Council of Canada (herein "NRC")
disclaims any warranties, expressed, implied, or statutory, of any kind or
nature with respect to the software, including without limitation any warranty
or merchantability or fitness for a particular purpose.  NRC shall not be liable
in any event for any damages, whether direct or indirect,
consequential or incidental, arising from the use of the software.

=head2 SYNOPSIS



=head2 DESCRIPTION and ACKNOWLEDGEMENTS


=head2 CONTACT

Mark Wilkinson (mwilkinson@gene.pbi.nrc.ca)

=cut


package GQ::Client::GO_evidenceBrowser;

use strict;
use Tk;
use Tk::Text;
use Carp;
use vars qw($AUTOLOAD);
Tk::Widget->Construct('GO_evidenceBrowser');

BEGIN {
    {
	#Encapsulated class data
	
	#___________________________________________________________
	#ATTRIBUTES
	my %_attr_data =	#     				DEFAULT    	ACCESSIBILITY
	  (	Codes				=> [["IMP","IGI","ISS","IPI","IDA","IEP","IEA","TAS","NAS","NR"], 'read/write'],
		AnnotationComplete  => [undef, 			'read/write'],
		currentCode			=> [undef, 			'read/write'],
		currentRef			=> [undef, 			'read/write'],
		EvidenceBox			=> [undef, 			'read/write'],
		GO					=> [undef, 			'read/write'],

	  );

	#_____________________________________________________________
	#METHODS, to operate on encapsulated class data

	# Is a specified object attribute accessible in a given mode
	sub _accessible  {
	    my ($self, $attr, $mode) = @_;
	    $_attr_data{$attr}[1] =~ /$mode/
	}

	# Classwide default value for a specified object attribute
	sub _default_for {
	    my ($self, $attr) = @_;
	    $_attr_data{$attr}[0];
	}

	# List of names of all specified object attributes
	sub _standard_keys {
	    keys %_attr_data;
	}

	use subs (keys %_attr_data)
    }
}				#end of BEGIN block

sub AUTOLOAD {
    no strict "refs";
    my ($self, $newval) = @_;

    $AUTOLOAD =~ /.*::(\w+)/;

    my $attr=$1;
    if ($self->_accessible($attr,'write')) {

	*{$AUTOLOAD} = sub {
	    if (defined $_[1]) { $_[0]->{$attr} = $_[1] }
	    return $_[0]->{$attr};
	};    ### end of created subroutine

###  this is called first time only
	if (defined $newval) {
	    $self->{$attr} = $newval
	}
	return $self->{$attr};

    } elsif ($self->_accessible($attr,'read')) {

	*{$AUTOLOAD} = sub {
	    return $_[0]->{$attr} }; ### end of created subroutine
	return $self->{$attr}  }


    # Must have been a mistake then...
    croak "No such method: $AUTOLOAD";
}


sub new{
	my ($caller, $frame, $mw, %args) = @_;
	
	return 0 if ((ref($frame) ne "Tk::Frame"));
	
	my $caller_is_obj = ref($caller);
    my $class = $caller_is_obj || $caller;

    my $self = bless {}, $class;

    foreach my $attrname ( $self->_standard_keys ) {
    	if (exists $args{$attrname}) {
		$self->{$attrname} = $args{$attrname} }
    elsif ($caller_is_obj) {
		$self->{$attrname} = $caller->{$attrname} }
    else {
		$self->{$attrname} = $self->_default_for($attrname) }
    }
	
    return if (!$self->GO || ref($self->GO) ne "GO_Annotation");  # this was not initialized with a valid GO object

	#$mw->configure(-title => "GO Evidence Browser");
	my $TopFrame =     $frame->Frame(-relief => 'raised')->pack(-side => "top", -expand => 1, -fill => "both");
	my $BottomFrame =  $frame->Frame(-background => 'black', -relief => 'sunken')->pack(-side => "top", -expand => 1, -fill => "x");
	my $VBottomFrame =  $frame->Frame(-background => 'black')->pack(-side => "top", -expand => 1, -fill => "x");
	my $left = $TopFrame->Frame(-background => "black")->pack(-side => "left", -expand => 1, -fill => "both");
	my $right =  $TopFrame->Frame(-background => "black")->pack(-side => "left", -expand => 1, -fill => "both");
	
	my $CODELabel =      $left->Label(-text => "CODE", -foreground => "white", -background => 'black')->pack(-side => "top", -anchor => "center");
	my $CODEText = $left->Scrolled("Text", -width => 4, -height => 12, -scrollbars => 'w',-wrap => "none", -background => "white")->pack(-side => "top", -anchor => "center");
	
	my $EVDLabel = $right->Label(-text => "EVIDENCE", -foreground => "white", -background => 'black')->pack(-side => "top", -anchor => "center");
	$self->EvidenceBox($right->Scrolled("Text", -width => 70, -height => 12, -wrap => "none", -background => "grey", )->pack(-side => "top", -anchor => "center"));
	
	
	my $REFLabel = $BottomFrame->Label(-text => "REFERENCE: ", -background => "black", -foreground => "white") -> pack(-side => "left", -anchor => "center");
	my $REFText  = $BottomFrame->Scrolled("Text", -height => 1, -wrap => 'none', -scrollbars => "s", -background => "white")->pack(-side => "left", -anchor => "center", -expand => 1, -fill => 'x');
	
	my $AddButton = $VBottomFrame->Button(-text => "Add This Reference")->pack(-side => "top", -anchor => "center");
	$AddButton->bind("<Button-1>" => sub {$self->_addReference; $REFText->delete("1.0", "end");});
	$AddButton->configure(-state => "disabled");

    my $FinishedButton = $VBottomFrame->Button(	-text => "DONE",
    				-command => sub {
    								if ($REFText->get("1.0", "end") ne "\n"){
    									$AddButton->eventGenerate("<ButtonPress-1>");
	 									$AddButton->eventGenerate("<ButtonRelease-1>");
	 								}				
    							})->pack(-side => "top", -anchor => "center");
    $self->AnnotationComplete($FinishedButton);    # we need to get to this from outside, so encapsulate it
	
	foreach my $code(@{$self->Codes}){
		next if (!$code);
		$CODEText->insert("end", $code, [$code]);
		$CODEText->insert("end", "\n");
		$CODEText->tagBind($code, "<Double-Button-1>", sub {
				$CODEText->tagConfigure("SELECTED", -foreground => "black");  # reset old
				$CODEText->tagDelete("SELECTED");                             # remove old tag
				$CODEText->tagAdd("SELECTED", $CODEText->tagRanges($code));   # set new tag
				$self->currentCode($code);  # encapsulate the currently selected answer
				if ($REFText->get('1.0', 'end') eq "\n"){
					$AddButton->configure(-state => "disabled")
				} else {
					$AddButton->configure(-state => "normal")
				}
				$CODEText->tagConfigure("SELECTED", -foreground => "red");
				});
	}

	$REFText->Subwidget('text')->bind("<Key-Return>" => sub {
	 	$AddButton->eventGenerate("<ButtonPress-1>");
	 	$AddButton->eventGenerate("<ButtonRelease-1>");
	 	$REFText->Subwidget('text')->break;
	 	}
	 	);
	
	$REFText->Subwidget('text')->bind("<Key>" => [sub {
		#return if $_[1] = "Return";
		if ($REFText->get('1.0', 'end') eq ""){
			$AddButton->configure(-state => "disabled");
		} elsif (($REFText->get('1.0', 'end') ne "\n") && ($CODEText->tagRanges("SELECTED"))){
			$AddButton->configure(-state => "normal");
		} else {
			$AddButton->configure(-state => "disabled");
		}
		my $ref = $REFText->get('1.0', 'end');
		chomp $ref;
		chomp $ref;
		$self->currentRef($ref);
	 	}, Ev("K")]);
	
	$self->EvidenceBox->configure(-state => "disabled");
    return $self;                        # return handle to self
}

sub _addReference {
    my ($self) = @_;
    my $GO = $self->GO;
    $self->EvidenceBox->configure(-state => "normal");
    $GO->addEvidence($self->currentCode, [$self->currentRef]);
    $self->EvidenceBox->delete('1.0', 'end');

	$self->EvidenceBox->insert('end', "GO Accession: " . $GO->GO_id . "  " . $GO->term . "\n");
	$self->EvidenceBox->insert('end',  "Definition: " . $GO->def . "\n");
	$self->EvidenceBox->insert('end', "Evidence: \n");

	my %evidence = %{$GO->evidence};

	foreach my $code(keys %evidence){
		$self->EvidenceBox->insert('end', "\tEvidence Type: $code\n");
  		foreach my $ref(@{$evidence{$code}}){
        	$self->EvidenceBox->insert('end', "\t\tReference: $ref\n");
		}
   }
   $self->EvidenceBox->configure(-state => "disabled");

}

1;








