package GQ::Client::txtHandAnnotate;
use strict;
use Carp;
use Tk::widgets qw(Dialog);
use Tk;
use Bio::Tk::GO_Browser;
use GQ::Client::GO_evidenceBrowser;


use vars qw( @ISA $AUTOLOAD );

BEGIN {
    {
	my %_attr_data =	#     DEFAULT    ACCESSIBILITY
	  ( -exportselection => [1,         "read/write"],
	    -background      => ["#ffeeff", "read/write"],
	    -foreground      => ["#000000", "read/write"],
	    -height          => [30,        "read/write"],
	    -width           => [60,        "read/write"],
	    -relief          => ["sunken",  "read/write"],
	    -takefocus       => [1,         "read/write"],
	    -wrap            => ['word',    "read/write"],
	    -scrollbars		=> ['se', 		"read/write"],
	    -highlightcolor => ['yellow', 	"read/write"],

	    annotation          => [undef,     "read/write"],
	    GOBrowserFrame   => [undef, 		"read/write"],
	    GOAnnotationFrame   => [undef, 		"read/write"],
	    Top				=> [undef, 		"read/write"],
	    TFrame          => [undef, 		"read/write"],
	    TD  	        => [undef, 		"read/write"],
	    BD				=> [undef, 		"read/write"],
	    MDF				=> [undef, 		"read/write"],
	    BFrame          => [undef, 		"read/write"],
	    LFrame          => [undef, 		"read/write"],
	    RFrame          => [undef, 		"read/write"],
		
	    # Buttons & labels below
	    submit			=> [undef,     "read/write"],
	    feature  		=> [undef,     "read/write"], # this is a re-used slot to hold all buttons.
	    blast			=> [undef,     "read/write"],
	    infolabel		=> [undef,     "read/write"],
	    clear			=> [undef,     "read/write"],

	  );


	# Is a specified object attribute accessible in a given mode
	sub _accessible  {
	    my ($self, $attr, $mode) = @_;
	    return $_attr_data{$attr}[1] =~ /$mode/
	}

	# Classwide default value for a specified object attribute
	sub _default_for {
	    my ($self, $attr) = @_;
	    return $_attr_data{$attr}[0]
	}

	# List of names of all specified object attributes
	# A hash so names are not repeated
	sub _standard_keys { keys %_attr_data }

	use subs (keys %_attr_data)
    }
} #end of BEGIN block

sub new {
    my ($caller, $top, $QueryScreen, $Feature, %args) = @_;
    my $caller_is_obj = ref($caller);
    my $class = $caller_is_obj || $caller;
    my $self=bless {},$class;

    foreach my $attrname ( $self->_standard_keys() ) {
    	if (exists $args{$attrname}) {
    	    $self->{$attrname} = $args{$attrname} }
    	elsif ($caller_is_obj) {
    	    $self->{$attrname} = $caller->{$attrname} }
    	else {
    	    $self->{$attrname} = $self->_default_for($attrname) }
    }

    foreach ($self->_standard_keys) {
	next if (!/^-/);       			# filter out all args that must not be passed through to the Tk parent
		$args{$_}=$self->{$_};      # set the defaults for Tk parent
    }

    my $tframe = $top->Frame(-background => "red");
    my $bframe = $top->Frame(-background => "white");
	my $maindummyframe = $top->Frame()->pack();
	my $tdummyframe = $tframe->Frame()->pack();
	my $bdummyframe = $bframe->Frame()->pack();
    my $lframe = $tframe->Frame(-background => "blue");
    my $rframe = $tframe->Frame(-background => "yellow");
    $self->Top($top);
	$self->TD($tdummyframe);
	$self->BD($bdummyframe);
	$self->MDF($maindummyframe);
	$self->TFrame($tframe);
	$self->BFrame($bframe);
    $self->LFrame($lframe);
    $self->RFrame($rframe);
    $self->annotation($self->LFrame->Scrolled('Text', %args));
	
    #____________________________________________________________________________________________________

    $self->feature($rframe->Button(	-text => "GO Annotation",
    							-command => sub {$self->_new_selectGOTerm($Feature, $QueryScreen)  # these are also tag/values, but are hard coded
    							})->pack(-side => 'top', -expand => '1', -fill => 'x'));

	$self->feature($rframe->Button(	-text => "Tag/Value pair",
    							-command => sub {$self->_addNewTagValue($Feature, $QueryScreen, "TagValue")  # this is an arbitrary key/value subroutine
    							})->pack(-side => 'top', -expand => '1', -fill => 'x'));

    $self->blast($rframe->Button(	-text => "Choose Blast Hit",
    							-command => sub {$self->_selectBlastHits($Feature, $QueryScreen)  # this presents a list of all Blast hits in the database
    							})->pack(-side => 'top', -expand => '1', -fill => 'x'));          # & allows selection of one "representative" as an annotation

    $self->clear($rframe->Button(	-text => "CLOSE SESSION",
    							-command => sub {$top->destroy})->pack(-side => 'top', -expand => '1', -fill => 'x'));

	$rframe->update;

    $self->annotation->delete("1.0", "end"); # clear the annotation window
    my @bindings = $self->annotation->Subwidget("text")->bindtags();
    shift @bindings;
    $self->annotation->Subwidget("text")->bindtags(\@bindings);


    $self->Fill($Feature);  # fill it with the current tag/values of that $Feature object

	# now that the frames are full, pack them
    $self->annotation->pack(-side => 'top', -expand => '1', -fill => 'both' );
	$lframe->pack(-side => 'left', -anchor => 'nw', -fill => 'x');
    $rframe->pack(-side => 'right',-anchor => "ne", -fill => 'x');
    $tframe->pack(-side => 'top', -fill => 'x');
    $bframe->pack(-side => 'bottom', -fill => 'x');

    return $self;
}

sub Fill {
	my ($self, $Feature) = @_;
	$self->annotation->delete("1.0", "end");
	foreach my $tag($Feature->all_tags){   # get the tags
		next if ($tag =~ /GO_annotation/);  # this is a special case
		my @values = $Feature->each_tag_value($tag);  # get the value of each tag
		foreach my $value(@values){
			$self->annotation->insert('end',"$tag=$value\n", [$tag]);  # write it as tag=value into the window and add a Tk-tag to the entire piece of text
			$self->annotation->tagBind($tag, "<Shift-Button-2>",       # bind the text to Shift-2 to allow the user to delete the entire entry with a single click
				sub {$Feature->remove_tag($tag);                   # during deletion, first remove the tag and all values of that tag
					my @ranges = $self->annotation->tagRanges($tag);   # then find all parts of the annotation text which have that Tk-tag
					my ($start, $stop);                            # (is returned as a list of paired coordinates)
					while ($start = shift @ranges){                # for each start/stop pair,
						$stop = shift @ranges;
						$self->annotation->delete($start, $stop);      # delete the text in that region
					}
				}
			); # end of tagBind($deletetag)
		}
	}
			
	$self->_unpackPrintGO($Feature);
}

sub _addNewTagValue {
	my ($self, $Feature, $QueryScreen, $tag) = @_;
	return if (!($Feature->id));    # ignore the request if this is not a dataabse feature
									# (non-database-features can not be annotated)
	
	my $mw = $QueryScreen->Toplevel();
	my $annotBrowser = GQ::Client::annotMenuBrowser->new($mw, $QueryScreen, [$Feature]);
	die "$annotBrowser" unless ref($annotBrowser) eq "GQ::Client::annotMenuBrowser";
	$annotBrowser->{Submit}->bind("<<REFRESH>>" => sub {$self->Fill($Feature)}); # this is an artificially generated event from annotMenuBrowser

}

sub DESTROY {
	my ($self)= @_;
	undef $self;
}

sub _new_selectGOTerm {
	my ($self, $Feature, $QueryScreen) = @_;
	return unless ($Feature->id);  # must be a database feature
	$self->GOBrowserFrame($self->BFrame->Frame(-background => 'purple'))->pack(-side => 'top');
	my $dummy = $self->GOBrowserFrame->Frame()->pack;
	my $GO = Bio::Tk::GO_Browser->new($self->GOBrowserFrame, TopWindow => $self->Top);
	return 0 unless $GO; # if no net connection, this will fail	
	$self->Top->update;
	$GO->browser->bind("<Double-Button-1>" => sub {
		my $GO_Annot = $GO->annotation;
		undef $GO;
		#$dummy->packForget;
		$self->GOBrowserFrame->packForget;
		$dummy->packForget;
		$self->BFrame->packForget;
		$self->GOAnnotationFrame($self->BFrame->Frame(-background => 'green'))->pack(-side => 'top');	
		$self->Top->configure(-title => "Hand Annotation Display");
		$self->_new_selectEvidenceReference($Feature, $GO_Annot);
		my $toplevel = $self->Top->toplevel;
		my $a = $toplevel->geometry;
		#print "\ngeometry $a\n";
		$a =~ /(\d+)x(\d+)\+-?(\d+)\+-?(\d+)/;      #get current screen position of top-level window eg. 500x300+20+-45
		$toplevel->geometry("$1"."x"."$2+10+10");  # set it so that the control bar is entirely visible at the top of the screen

		});             					
	my $toplevel = $self->Top->toplevel;
	my $a = $toplevel->geometry;
	#print "\ngeometry $a\n";
	$a =~ /(\d+)x(\d+)\+-?(\d+)\+-?(\d+)/;      #get current screen position of top-level window eg. 500x300+20+-45
	$toplevel->geometry("$1"."x"."$2+10+10");  # set it so that the control bar is entirely visible at the top of the screen
}


sub _new_selectEvidenceReference {
	my ($self, $Feature, $GO_Annot) = @_;
	
	my $evid = GQ::Client::GO_evidenceBrowser->new($self->GOAnnotationFrame, $self->Top, GO => $GO_Annot);
	$self->BFrame->pack(-side => 'top', -fill => 'x');
	$evid->AnnotationComplete->bind("<Button-1>" => sub {
	        $GO_Annot = $evid->GO;  # replace with the new copy
	        $Feature->GO_store([$GO_Annot]);
			$self->GOAnnotationFrame->packForget;
			$self->BFrame->packForget;
			$self->TD->packForget;
			$self->BD->packForget;
			$self->GOAnnotationFrame(undef);
			$self->GOBrowserFrame(undef);
			$self->Top->update;
			$self->TD->pack;
			$self->BD->pack;
    		$self->BFrame->pack(-side => 'top');
			$self->Top->configure(-title => "Hand Annotation Display");
            $self->Fill($Feature);
            });
}

sub _unpackPrintGO {
	my ($self, $Feature) = @_;
	return unless ($Feature->can("GO"));
	$Feature->GO_find;
	my @GOs = @{$Feature->GO};
	foreach my $GO(@GOs){
		my $GO_id = $GO->GO_id;
		my $id = $GO->id;
		my $Term = $GO->term;
		my %evid = %{$GO->evidence};
		$self->annotation->insert('end',"\n$id  $Term\n", [$GO_id]);  # write it as tag=value into the window and add a Tk-tag to the entire piece of text
		foreach my $code(keys %evid){
			$self->annotation->insert('end', "\tEvidence Type: $code\n", [$GO_id]);
			foreach my $ref(@{$evid{$code}}){
				$self->annotation->insert('end',"\t\tReference: $ref\n", [$GO_id]);
			}
		}
		$self->annotation->tagBind($GO_id, "<Shift-Button-2>",       # bind the text to Shift-2 to allow the user to delete the entire entry with a single click
				sub {
					$Feature->GO_delete($id);                   # during deletion, first remove the tag and all values of that tag
					$self->Fill($Feature);
				}); # end of tagBind($deletetag)
	}
}



sub _selectBlastHits {

	my ($self, $Feature, $QueryScreen) = @_;
	return if (!($Feature->id));
	
	my $BlastText = $self->BFrame->Scrolled('Text', -wrap => "word", -background => '#FFFFFF')->pack;
	$BlastText->insert('end', "Select the best Blast Hit from the options below\n\n");
	
	my %FeatureHash;
	if ($Feature->can("gene_name")) {   						# is this a gene feature (true) or not
		foreach my $subfeature(($Feature->sub_SeqFeature)){# if so, then get the subfeatures
			$FeatureHash{$subfeature->id} = $subfeature;		# stick them into a hash to be sent to the getBlast routine
		}                                                   # (note that the key to this hash is irrelevant)
	} else {                                                   # otherwise we have only a single exon
		$FeatureHash{($Feature->id)}= $Feature;	            # stick it into a hash of one feature
	}
	my @results = $QueryScreen->getBlastHit(\%FeatureHash);  # get the blast hits for this(these) feature(s)
	
	my $index = 0;
	foreach my $result(@results) {                            # this routine is pretty much identical to the ones above...
		my $hix = "hit_$index";
		$BlastText->insert('end', $result, [$hix]);
		$BlastText->tagBind($hix, "<Button-2>",
			sub {chomp($result);
				$Feature->add_tag_value("Blast_Hit",$result);
				my $deletetag = "BlastHit";
				$self->annotation->insert('end',"Blast_Hit=\"$result\"\n", [$deletetag]);
				$self->annotation->tagBind($deletetag, "<Shift-Button-2>",
						sub {$Feature->remove_tag("Blast_Hit");
							$self->Fill($Feature);
							
						}); # end of tagBind($deletetag)               					
				$BlastText->destroy;
				$self->BFrame->packForget;
				 $self->BFrame->pack();

			});  # end of tagBind($hix)
		++$index;
	} # end of foreach $result
}


sub AUTOLOAD {
    no strict "refs";
    my ($self, $newval) = @_;

    $AUTOLOAD =~ /.*::(\w+)/;

    my $attr=$1;
    if ($self->_accessible($attr,'write')) {

	*{$AUTOLOAD} = sub {
	    if (defined $_[1]) { $_[0]->{$attr} = $_[1] }
	    return $_[0]->{$attr};
	};    ### end of created subroutine

###  this is called first time only
	if (defined $newval) {
	    $self->{$attr} = $newval
	}
	return $self->{$attr};

    } elsif ($self->_accessible($attr,'read')) {

	*{$AUTOLOAD} = sub {
	    return $_[0]->{$attr} }; ### end of created subroutine
	return $self->{$attr}  }


    # Must have been a mistake then...
    croak "No such method: $AUTOLOAD";
}

1;
