package GQ::Root;
use strict;
use Carp;
no strict 'refs';

sub create{

    my ($class,%_attr_data)=@_;                  # $class is GQ::Root - don't use!
    my $prefix=caller;
    my $rootlevel=0;
    if ($_attr_data{rootlevel}) {
	$rootlevel=1;
	delete $_attr_data{rootlevel};
    }

    #Encapsulated class data is in %_attr_data

    unless (defined &{$prefix.'::new'}) {
	*{$prefix."::new"} = sub {
	    my ($caller,%arg)=@_;
	    my $self=&{$prefix."::_new"}($caller,%arg);
	    $self->_initialize if $self->can('_initialize');
	    return $self;
	};
    }

    if ($rootlevel) {

	# Does a specified attribute exist?
	*{$prefix."::_exists"} = sub {
	    my ($attr) = @_;
	    return exists $_attr_data{$attr};
	};

	# Is a specified object attribute accessible in a given mode
	*{$prefix."::_accessible"}  = sub {
	    my ($attr, $mode) = @_;
	    $_attr_data{$attr}[1] =~ /$mode/
	};

	# Classwide default value for a specified object attribute
	*{$prefix."::_default_for"} = sub {
	    my ($attr) = @_;
	    $_attr_data{$attr}[0];
	};

	# List of names of all specified object attributes
	*{$prefix."::_standard_keys"} = sub {
	    keys %_attr_data;
	};

	# List of names of all specified object attributes
	*{$prefix."::_keys"} = sub {
	    keys %_attr_data;
	};



	*{$prefix."::_new"} = sub {
	    my ($caller, %arg) = @_;
	    my $caller_is_obj = ref($caller);
	    my $class = $caller_is_obj || $caller;
	    my $self= bless {}, $class;
	    foreach my $attrname ( &{$prefix."::_standard_keys"}() ) {
		if (exists $arg{$attrname}) {
		    $self->{$attrname} = $arg{$attrname} }
		elsif ($caller_is_obj) {
		    $self->{$attrname} = $caller->{$attrname} }
		else {
		    $self->{$attrname} = &{$prefix."::_default_for"}($attrname) }
	    }
	    return $self;
	};

    } else {   # ELSE NOT ROOTLEVEL

	my $parent=${$prefix."::ISA"}[0];  #find immediate parent class (instead of self->SUPER

	# Does a specified attribute exist?
	*{$prefix."::_exists"} = sub {
	    my ($attr) = @_;
	    if (exists $_attr_data{$attr}) {
		return 1;
	    } else {
		return &{$parent."::_exists"}($attr);
	    }
	};

	# Is a specified object attribute accessible in a given mode
	*{$prefix."::_accessible"}  = sub {
	    my ($attr, $mode) = @_;
	    return $_attr_data{$attr}[1] =~ /$mode/ if exists $_attr_data{$attr};
	    return &{$parent."::_accessible"}($attr,$mode);
	};

	# Classwide default value for a specified object attribute
	*{$prefix."::_default_for"} = sub {
	    my ($attr) = @_;
	    return $_attr_data{$attr}[0] if exists $_attr_data{$attr};
	    return &{$parent."::_default_for"}($attr);
	};

	# List of names of all specified object attributes
	*{$prefix."::_standard_keys"} = sub {
	    my %hash;
	    foreach (&{$parent."::_standard_keys"}, keys %_attr_data) {
		$hash{$_}++
	    }
	    return keys %hash;
	};

	# List of names of all locally specified object attributes
	*{$prefix."::_keys"} = sub {
	    keys %_attr_data;
	};

	*{$prefix."::_new"} = sub {
	    my ($caller, %arg) = @_;
	    my $caller_is_obj = ref($caller);
	    my $class = $caller_is_obj || $caller;
	    my $self=&{$parent."::_new"}($parent,%arg);
	    bless $self, $class;
	    foreach my $attrname ( &{$prefix."::_standard_keys"}() ) {
		if (exists $arg{$attrname}) {
		    $self->{$attrname} = $arg{$attrname} }
		elsif ($caller_is_obj) {
		    $self->{$attrname} = $caller->{$attrname} }
		else {
		    $self->{$attrname} = &{$prefix."::_default_for"}($attrname) }
	    }
	    return $self;
	};
    }

    foreach my $attr (&{$prefix."::_keys"} ) {
	no strict "refs";
	#this is the crucial test, so we don't write over hardcoded routines
	next if defined &{$prefix.'::'.$attr};
	if (&{$prefix."::_accessible"}($attr,'write')) {
	    *{$prefix.'::'.$attr} = sub {
		if (defined $_[1]) {
		    if ($_[0]->can('_update_db')) {
			if ($_[0]->_update_db($attr,$_[1])) {
			    $_[0]->{$attr} = $_[1];
			} else {
			    die "Database update unsuccessful: $DBI::errstr, $!";
			}
		    } else {
			$_[0]->{$attr} = $_[1];
		    }
		}
		return $_[0]->{$attr}
	    };  ### end of created subroutine
	} elsif (&{$prefix."::_accessible"}($attr,'read')) {
	    *{$prefix.'::'.$attr} = sub {
		return $_[0]->{$attr} };
	} else {     # Must have been a mistake then...
	    return;  #return undef
	}
    }
}

1;
