package GQ::Server::DB::DbObj;
use strict;
use DBI;
use Carp;

sub new {
    my ($caller, $user, $pass, $db, $ip) = @_;
    my $class=ref($caller)||$caller;
    my $self= {};
    bless $self, $class;
    my $dsn = "DBI:mysql:".$db.":".$ip;
    my ($dbh);
    eval {
	$dbh = DBI->connect($dsn, $user, $pass,
			    { AutoCommit => 0,
			      RaiseError => 1,
			    });
	$self->{autocommit}=0;
    };
    if ($@) {
	$dbh = DBI->connect($dsn, $user, $pass,
			    { AutoCommit => 1,
			      RaiseError => 1,
			    });
	$self->{autocommit}=1;
    }
    if ($dbh){
	$self->{dbh}=$dbh;
	$self->{user}=$user;
	$self->{db}=$db;
	$dbh->do("use $db");
	return ($self);
    } else {
	return;
    }
}

sub all_databases {
    my ($self)=@_;
    my @dbs;
    my $sth=$self->{dbh}->prepare('SHOW DATABASES');
    $sth->execute;
    while (my ($db)=$sth->fetchrow_array) {
	push @dbs,$db;
    }
    return @dbs;
}

sub use_this {
    my ($self,$db)=@_;
    my $sth=$self->{dbh}->do("use $db")
      or return $DBI::errstr;
    $self->{db}=$db;
    return 1;
}

sub dbh { return $_[0]->{dbh} }

sub user { return $_[0]->{user} }

sub db { return $_[0]->{db} }

1;







