# Feature::mod module for Workbench II

# by David Block <dblock@gene.pbir.nrc.ca>

# Copyright David Block and NRC-PBI

# POD Documentation - main docs before the code

=head1 NAME

Feature::mod - Modifiable Feature Object for Workbench II

=head1 SYNOPSIS

=head2 Purpose of this class

The purpose of this class is to create a class of Features
that are safe to modify.

They will have the source_tag 'hand_annotation' and the user
will be able to modify the start and end values.

Otherwise, it inherits everything from the Feature class.

do perldoc Feature.pm

=head2 Creating a Feature::mod

use Feature::mod;

$feature2=Feature::mod->new(%$feature1);

This clones feature1, but gives it the new source_tag 'hand_annotation'
and allows the user to modify it.

=head1 DESCRIPTION

Feature is a feature on a sequence. It follows the GFF format in
terms of how the data is stored.  Its start and stop values are relative to
Virtual Contigs, whose position is stored in the LookUp table.

It lives in the database in the Feature table.  It is a GenericFeature, which
means it implements Bio::SeqFeatureI as well as all the methods common to Feature,
Gene, Feature::Annotation, and Feature::mod.

=head1 FEEDBACK

Like it or lump it, report to dblock@gene.pbi.nrc.ca.  Feel free to add
to the docs available at
http://bioinfo.pbi.nrc.ca/dblock/wiki

=head2 Reporting Bugs

Email the author with any bug reports.

=head1 AUTHOR - David Block

email dblock@gene.pbi.nrc.ca

=cut

package GQ::Server::Feature::mod;
$VERSION = 1.00;
use strict;

use vars qw( @ISA);  #Keep 'use strict' happy

use Carp;
use DBI;
use GQ::Root;

use GQ::Server::Feature;
@ISA = qw(GQ::Server::Feature);


{GQ::Root->create;}
### write in any custom subroutines here

sub new {
    my ($caller, %arg) = @_;
    my $caller_is_obj = ref($caller);
    my $class = $caller_is_obj || $caller;
    delete $arg{id};        #DELETE ID so that new features have a new id
                            #Otherwise they simply overwrite Feature table entries
    $arg{'access'}="rw";
	my $self=$class->SUPER::new(%arg);
	$self->adaptor->change_type($self, $self->type);
    return $self;
}

sub transform {
    my ($caller, %arg) = @_;
    return unless $arg{access} eq 'rw';
    my $caller_is_obj = ref($caller);
    my $class = $caller_is_obj || $caller;
                            #This version simply makes a Feature modifiable
    my $self=$class->_new(%arg);
	$self->adaptor->change_type($self, $self->type);
    return $self;
}


sub increment_right {
    my ($self,$incr)=@_;
    $self->contig_stop($self->contig_stop + $incr);
    $self->length($self->end - $self->start + 1);
}

sub decrement_right {
    my ($self,$incr)=@_;
    $self->contig_stop($self->contig_stop - $incr);
    $self->length($self->end - $self->start + 1);
}

sub increment_left {
    my ($self,$incr)=@_;
    $self->contig_start($self->contig_start + $incr);
    $self->length($self->end - $self->start + 1);
}

sub decrement_left {
    my ($self,$incr)=@_;
    $self->contig_start($self->contig_start - $incr);
    $self->length($self->end - $self->start + 1);
}


1;








