package GQ::Server::GBFlat::Context;
use strict;
use DBI;
use vars qw( @ISA $AUTOLOAD );  #Keep 'use strict' happy
use Carp;

{
    my %type_hash=(
			# a list of interesting genbank feature types with correct capitalization and punctuation
			# and their associated genquire feature type
			# note that 'gene and transcript' type are mandatory
			gene		=>'GQ::Server::Gene',
			transcript	=>'GQ::Server::Transcript',
			
			exon		=>'GQ::Server::Feature',
			tRNA		=>'GQ::Server::Gene',
			promoter	=>'GQ::Server::Feature',
			intron		=>'GQ::Server::Feature',
			polyA_site	=>'GQ::Server::Feature',
			misc_feature=>'GQ::Server::Feature',
			DEFAULT		=>'GQ::Server::Feature',
		  );

    sub _type {
	my ($self,$type)=@_;
	if (defined $type_hash{$type}){return $type_hash{$type}}
	else {return $type_hash{'DEFAULT'}}
    }
    
    sub _get_types {
		my ($self)=@_;
		return %type_hash
	}


}

sub new {
    my ($caller, $GBobj)=@_;
    my $class=ref($caller)||$caller;
    my $self= {};
    bless $self, $class;
    $self->{GBobj}=$GBobj;    # store the underlying BioPerl Seq object to manipulate it
	return $self;
}

sub adaptor {
    my ($self, $object)=@_;
    my $adaptor_class=$self->_adaptor_for($object);
    unless ($self->{adaptor}{$adaptor_class}) {
	eval "require $adaptor_class;";
	if ($@) {
	    die "$@";
	}
	$self->{adaptor}{$adaptor_class}=$adaptor_class->new(context=>$self);
    }
    return $self->{adaptor}{$adaptor_class};
}

sub _adaptor_for {
    my ($self, $thing)=@_;
    #this is a catalogue of adaptors that matches the object with the correct adaptor
    #for this context, which in this case is a
    #mysql database environment
	
    my $adaptor='GQ::Server::GBFlat::Adaptor::'; # COMMON PREFIX FOR ALL ADAPTORS!

    my $object=ref($thing)||$thing;
    #most specific first
    if ($object eq 'GQ::Server::Feature::inMemory') {
	$adaptor .= 'Feature::inMemoryAdaptor';
    } elsif ($object eq 'GQ::Server::Feature::mod') {
	$adaptor .= 'FeatureAdaptor';
    } elsif ($object eq 'GQ::Server::Feature') {
	$adaptor .= 'FeatureAdaptor';
    } elsif ($object eq 'GQ::Server::Gene') {
	$adaptor .= 'GeneAdaptor';
    } elsif ($object eq 'GQ::Server::Transcript') {
	$adaptor .= 'TranscriptAdaptor';
    } elsif ($object eq 'GQ::Server::Sequence') {
	$adaptor .= 'SequenceAdaptor';
    } elsif ($object eq 'GQ::Client::Chat') {
	$adaptor .= 'ChatAdaptor';
    } elsif ($object eq 'GQ::Server::Organism') {
	$adaptor .= 'OrganismAdaptor';
    } elsif ($object eq 'GQ::Server::Contig') {
	$adaptor .= 'ContigAdaptor';
    } else {
	$adaptor .= 'ObjectAdaptor';
    }

    return $adaptor;
}


=head2 all_orgs_by_id

 Title   : all_orgs_by_id
 Usage   : $context->all_orgs_by_id;
 Function: returns a list of GQ::Server::Organism objects available from that data source
 Returns : returns a list of GQ::Server::Organism objects
 Args    : none
 Note    : THIS IS A REQUIRED Context FUNCTION FOR ANY ADAPTOR LAYER

=cut


sub all_orgs_by_id {
    require GQ::Server::Organism;
    my ($self)=@_;
    my (@organisms);
	my $GBobj = $self->GBobj;
	
	my $species=$GBobj->species->binomial;
	push @organisms, GQ::Server::Organism->new(
		context=> $self,
		common => $species,
		latin  => $species,
		code   => 1,
		id     => $self->DEFAULT_ID,
		version=> $self->DEFAULT_VERSION,
						  );
    return @organisms;
}

=head2 add_org

 Title   : add_org
 Usage   : $context->add_org(
			     common => $common_name,
			     latin  => $latin_name,
			     code   => $two_letter_code,
                            );
 Function: adds an organism to the database, and creates a new GQ::Server::Organism object
 Returns : the newly created GQ::Server::Organism object
 Args    : a hash containing
            common => $common_name,
            latin  => $latin_name,
            code   => $two_letter_code
            for the organism


=cut

sub add_org {
    
    my ($self, %args,)=@_;

    return 0;
}

sub commit {
    my ($self)=@_;
	return 0;
}

sub rollback {
    my ($self)=@_;
	return 0;

}

sub COMMIT {
	return 1;
}

sub GBobj { return $_[0]->{GBobj} }

sub dbh { return 0 }

sub user { return "none" }

sub DEFAULT_ID {1}
sub DEFAULT_VERSION {1}

=head2 organism

 Title   : organism
 Usage   : $context->organism($newval)
 Function: gets/sets the current organism, creating a new object if needed
 Returns : the current GQ::Server::Organism object for this context
 Args    : newvalue (optional), which could be a GQ::Server::Organism object, or the string 'default'


=cut

sub organism {
    require GQ::Server::Organism;
    my ($self)=@_;
    my (@organisms);
	my $GBobj = $self->GBobj;
	
	my $species=$GBobj->species->binomial;
	return GQ::Server::Organism->new(
		context=> $self,
		common => $species,
		latin  => $species,
		code   => 1,
		id     => $self->DEFAULT_ID,
		version=> $self->DEFAULT_VERSION,
						  );
 
}

sub version {return $_[0]->organism->version}

sub get_contigs_by_name {
    my ($self)=@_;
	my @list;
	push @list, $self->GBobj->accession_number;
    return @list;
}

sub get_chrs_by_id {
    my ($self)=@_;
	my @list;
	push @list,"1";
	# this is returning a list of one element
	# since genbank flat files do not have
	# multiple chromosomes (or... I guess they do
	# but I'm not sophisticated enough to care)
    return @list;
}

sub get_ordered_assemblies_by_chr {
	# leave this code alone
    my ($self, $chr_id)=@_;
	my $GB = $self->GBobj;
	my %struct;
	
	# $struct{assembly_id}, [$contigname, $contiglength]
    push @{$struct{1}},[$GB->accession_number,$GB->length];

    return \%struct;
}

sub get_next {
    my ($self,$present,$np)=@_;

    return $present;
}

sub contig {
	
	require GQ::Server::Contig;
    my ($self, $contigname)=@_;  # I presume this is contig by name
    unless ($self->{contiglist}{$contigname}) {
	my $contigobj=GQ::Server::Contig->new(
		name   =>$contigname,
		context=>$self,
		);
	$self->{contiglist}{$contigname}=$contigobj;
	$self->{contig_by_id}{$contigobj->id}=$contigobj;
    }
    return $self->{contiglist}{$contigname};
}

sub contig_by_id {
    require GQ::Server::Contig;
    my ($self, $contig_id)=@_;
    unless ($self->{contig_by_id}{$contig_id}){
	my $contigobj=GQ::Server::Contig->new(
		name   =>$contig_id,
		context=>$self,
		);
	$self->{contig_by_id}{$contig_id}=$contigobj;
	$self->{contiglist}{$contig_id}=$contigobj;
	}
    return $self->{contig_by_id}{$contig_id};
}

sub get_contig_sequence {
    my ($self, $contig)=@_;
    my $contigobj=$self->contig($contig);
    return $contigobj->sequence;
}

sub get_contig_length {
    my ($self, $contig)=@_;
    my $contigobj=$self->contig($contig);
    return $contigobj->length;
}

sub get_contig_id {
    my ($self, $contig)=@_;
    my $contigobj=$self->contig($contig);
    return $contigobj->id;
}

sub get_boundaries {
    my ($self, $contig)=@_;
    my $contigobj=$self->contig($contig);
    return $contigobj->boundaries;
}


sub _get_contig_start_stop {
    my ($self, $contig)=@_;
    my $contigobj=$self->contig($contig);
    my $assembly=$contigobj->assembly;
    my $start=$contigobj->abs_start;
    my $len=$contigobj->length;
    my $stop=$start+$len-1;
    return ($assembly,$start,$stop);
}

sub find_assembly {
    my ($self, $contig)=@_;
    my $contigobj=$self->contig($contig);
    return $contigobj->assembly;
}

#This is a bulk load of contig info, organized by name.  I'll leave it for now, but it may be rationalized soon.
sub get_contig_info_by_name {
    my ($self)=@_;
	my $GB = $self->GBobj;
    my %seq;
#          name,        Tiling_Path.contig_id,   abs_start
	$seq{$GB->primary_id}=[$GB->accession_number,1];
    
    return \%seq;
}

#the following three methods are schema-dependent, and should only be implemented where they make sense
sub insert_contig {
    my ($self, %args)=@_;
    return 0;
}

sub insert_contigAssembly {
    my ($self, %args)=@_;

    return 0;
}

sub insert_Assembly {
    my ($self, %args)=@_;

    return 0;
}

sub get_EST_sources {
    my ($self)=@_;

    return [];
}

sub get_EST_sequence {
    my ($self, $EST_name)=@_;
    return "";
}



sub get_EST_hits {
    my ($self, %args)=@_;

    return [];
}

sub get_common_exons {
    my ($self, $fid)=@_;

    return [];
}

sub get_tags {
    my ($self)=@_;

    return [];
}


sub _prepare_handles {
    my ($self)=@_;
    $ContextPicker::sth_list=[undef, undef, undef];
	return $ContextPicker::sth_list;
}

sub parse_Blast_to_db {
    my ($self, $DB_ID, $BlastObj)=@_;
	return 0;
}

sub create_tag {
    my ($self, $tag) = @_;
	return 0;
}

sub checklock {
    my ($self, %args) = @_;
	return 0;
}

sub get_location {
    my ($self, $contig_id, $contig_start, $contig_stop) = @_;
    
    my $contigobj=$self->contig_by_id($contig_id);
    $contigobj || return;
    my $abs_start=$contigobj->abs_start;
    my $start=$abs_start+$contig_start-1;
    my $stop= $abs_start+$contig_stop -1;
    return ($start,$stop);
}

sub lock {
	# should return 1 by default for flat files
    my ($self,$parm,$new)=@_;
	return 1;
}

sub _look_lock {
    my ($self,$assembly,$newstart,$newstop)=@_;
	return 0;
}

sub get_flagged_features {
    my ($self,$flag)=@_;
    my @list;
    return \@list;
}

sub get_flagged_contigs {
    my ($self,$flag)=@_;
    my @list;
    return \@list;
}

sub remove_flag {
    my ($self,$flag)=@_;
	return 0;
}

sub _check_flag {
    my ($self,$flag)=@_;
	return 0;
}

sub add_flag {
    my ($self, %args)=@_;
	return 0;
}

sub rename_flag {
    my ($self,$old_flag,$new_flag)=@_;
	return 0;
}

sub all_flags {
    my ($self)=@_;
    my @flags;
    return @flags;
}

sub flag_text {
    my ($self,%args)=@_;
	return 0;
}


1;







