package GQ::Server::Organism;
use strict;
use DBI;
use vars qw( @ISA );  #Keep 'use strict' happy
use Carp;
use GQ::Server::Object;
use GQ::Root;

@ISA=qw(GQ::Server::Object);

{
	#Encapsulated class data

                    	          #    DEFAULT         ACCESSIBILITY
    GQ::Root->create(  common      =>  [undef,        'read/write'],
		       latin       =>  [undef,        'read/write'],
		       code        =>  [undef,        'read/write'],
		       id          =>  [undef,        'read'],
		       version     =>  [undef,        'read/write'],
		    );

}

sub _initialize {
    my ($self) = @_;
    $self->adaptor($self->context->adaptor($self));
}

sub version {                #don't want to try to update table - this is in a different place
    my ($self,$version)=@_;
    if (defined $version) {
	$self->{version}=$version;
    }
    return $self->{version};
}

sub selection {
    my ($self)=@_;
    return $self->latin.' v.'.$self->version;
}

1;
