package GQ::Client::ShowSequence;
use Tk;
use Bio::PrimarySeq;

sub new {
    my ($self,$parent, $SeqObj)=@_;
    return GetSelectedSequence($parent, $SeqObj);
}

sub destroy {
    
}

sub GetSelectedSequence {

# must first get the start/stop of each selected exon.  Selected exons have the tag "selected_widget"

    my ($parent, $SeqObj)=@_;

    my (@SelectedSeqs,@SelectedColors,$dir);

#   if (Tk::Exists($frmSeqDisp)) {$frmSeqDisp->destroy()}

    my %exons;
    my @exonIDs = @{$SeqObj->getSelectedIDs};  	# get the list of exons on the working map that are currently tagged as select
    foreach (@exonIDs) {
		my $exon=$SeqObj->AllFeatures($_);
		next if (!($exon->primary_tag =~ /sngl|init|term|intr/i));
		$exons{$exon->each_tag_value('id')}=$exon;
		$dir=$dir || $exon->strand;
    }

	unless (defined($dir)){
		$parent->setMessage("no displayable types selected");
		return;
	}# if there are no exon types selected this will be true

    my $frmSeqDisp = $parent->Toplevel(-title => "Sequence and Translation of Selected Exons");
    my $txtSeqDisp = $frmSeqDisp->Scrolled('Text',  -selectbackground => 'yellow', -scrollbars => "se", -width => 90, -height => 40, -background => "#002222")->pack(-side => 'left');
    my $txtTransDisp = $frmSeqDisp->Scrolled('Text', -selectbackground => 'yellow',-scrollbars => "se",-width => 30, -height => 40, -background => "#eeffff")->pack(-side => 'right');


    if ($dir =~ /-/) {
	foreach (sort { $b->end <=> $a->end } values %exons) {
	    my $seq=Bio::PrimarySeq->new( -seq => ($SeqObj->MapSeq->getseq($_->start,$_->end)));
	    push @SelectedSeqs, ($seq->revcom->seq);    		     # push that sequence onto an array for later manipulation
	    push @SelectedColors, (${$SeqObj->current_colors}{$_->source_tag});  	# because we must do the exon translation later it is necessary
	                                                                # to store the exons colors in the order in which they were pushed
	    DisplaySeq($dir, $_, $seq, $SeqObj, $txtSeqDisp);
	    $frmSeqDisp->update;
	}        #reverse sorted
    }
    else {
	foreach (sort { $a->start <=> $b->start } values %exons) {
	    my $seq=Bio::PrimarySeq->new( -seq => ($SeqObj->MapSeq->getseq($_->start,$_->end)));
	    push @SelectedSeqs, ($seq->seq);     # push that sequence onto an array for later manipulation
	    push @SelectedColors, (${$SeqObj->current_colors}{$_->source_tag});  	# because we must do the exon translation later it is necessary
	                                                                # to store the exons colors in the order in which they were pushed
	    DisplaySeq($dir, $_, $seq, $SeqObj, $txtSeqDisp);
	    $frmSeqDisp->update;
	}       #forward sorted
    }
    #print "SelectedSeqs are @SelectedSeqs\n";
    foreach (@SelectedSeqs) {
	s/\s//;
    }
    my $SelectedSeq = Bio::PrimarySeq->new(-seq => (join '',@SelectedSeqs), -moltype => 'dna');
    my $SelectedTrans = $SelectedSeq->translate();       # returns a ::Seq (protein) object
    $txtTransDisp->insert('end', $SelectedTrans->seq());

    my $index="end";
    while (($index = $txtTransDisp->search(-backwards, "*", $index, "1.0"))){     # find all stop codons and tag them for highlighting
	$txtTransDisp->tagAdd("StopCodon", $index);                            # this is kind of a bizarre way of doing it, but it works
    }
    $txtTransDisp->tagConfigure("StopCodon", -background => "red");     # light up all stop codons in red

    $frmSeqDisp->update;

    return $frmSeqDisp;
}

sub DisplaySeq {
    my ($dir, $exon, $seq, $SeqObj, $txtSeqDisp) = @_;

    $txtSeqDisp->tagConfigure($exon->source_tag, -foreground => ${$SeqObj->current_colors}{$_->source_tag});   # prepare tags for printing in color depending on the genefinder source_tag
    
    if ($dir =~ /-/) {
	$txtSeqDisp->insert('end', ($seq->revcom->seq, [$exon->source_tag, $exon->each_tag_value('id')]));	# write the sequence into the text window; reverse-compliment if necessary, and add the source_tag name and ExonID tags
    }
    else {
	$txtSeqDisp->insert('end', ($seq->seq, [$exon->source_tag, $exon->each_tag_value('id')]));
    }
}

1;




