package GQ::Client::Chat;
use strict;
use Carp;
use DBI;
use Tk;
#use txtOutput;

use vars qw( @ISA );
@ISA=qw(Tk::MainWindow);

{
    my $outputheight=24;
    my $outputwidth=50;

    sub outputheight {$outputheight}
    sub outputwidth {$outputwidth}
}

sub new {
    my ($class, $parent, $context)=@_;
    my $self=$parent->Toplevel(-title => "GQChat");
    bless $self, $class;
    $self->{adaptor}=$context->adaptor($self);
    $self->drawWindow;
    $self->update;
    return $self;
}

sub adaptor {
    return $_[0]->{adaptor};
}

sub destroy {
    my ($self)=@_;
    $self->adaptor->withdraw_user;
}

sub drawWindow {
    my ($self)=@_;
    my (%target,$update);
    $self->{output}=$self->Scrolled("Text",
				   -height=>$self->outputheight,
				   -width =>$self->outputwidth,
				   -scrollbars=>'oe',
				  )->pack(-side=>'top');
    $self->{input}=$self->Text(-height => 4,
			      -width  =>$self->outputwidth,
			     )->pack(-side  =>'top',
				    );
    $self->{left_frame} =$self->Frame()->pack(-side =>'left');
    $self->{right_frame}=$self->Frame()->pack(-side =>'right');
    $self->{left_frame}->Label(-text=>"Online now:")->pack(-anchor =>'nw',
							  );
    foreach ($self->adaptor->find_possible_targets) {
	$self->{poss_targets}{$_}=
	  $self->{left_frame}->Checkbutton(-text => $_,
					   -variable => \$target{$_},
					   -command => sub {$self->set_target(%target)},
					  )->pack(-anchor=>'nw',
						 );
    }
    $self->{input}->focus();
    $self->{submit}=$self->{right_frame}->Button(-text=>'Submit',
						 -command=>sub {
						     $self->get_msg
						 })->pack(-anchor=>'ne');
    $self->{targets}=$self->{right_frame}->Button(-text=>"Check who's online",
						  -command=>sub {
						      $self->check_for_targets
						  })->pack(-anchor=>'ne');
    $self->{updatenow}=$self->{right_frame}->Button(-text=>'Update Now',
						    -command=>sub {
							$self->read_msg
						    })->pack(-anchor=>'ne');
    $self->{update}=$self->{right_frame}->Checkbutton(-text=>'Update On',
						      -indicatoron=>0,
						      -variable => \$update,
						      -command=>sub {
							  $self->check_for_msg($update)
						      })->pack(-anchor=>'ne');
    $self->bind('<Key-Return>',sub {$self->get_msg});
    $self->bind('<Key-KP_Enter>',sub {$self->get_msg});
    $self->OnDestroy(sub {$self->check_for_msg(0);
			  $self->destroy;
		      });
}

sub set_target {
    my ($self,%target)=@_;
    $self->{target}=\%target;
}

sub check_for_targets {
    my ($self)=@_;
    my %target;
    foreach (keys %{$self->{poss_targets}}) {
	$self->{poss_targets}{$_}->packForget;
    }
    $self->set_target(''=>0);
    foreach ($self->adaptor->find_possible_targets) {
	$self->{poss_targets}{$_}=
	  $self->{left_frame}->Checkbutton(-text => $_,
					   -variable => \$target{$_},
					   -command => sub {$self->set_target(%target)},
					  )->pack(-anchor=>'nw',
						 );
    }
}

sub check_for_msg {
    my ($self,$var)=@_;
    $self->{cts_update}=$var;
    while ($self->{cts_update}==1) { # as long as cts update is on
	$self->read_msg;
	for (1..500) {
	    if ($self->{cts_update} == 1) {
		$self->update;
		select(undef,undef,undef,0.01)
	    } else {
		return;
	    }
	}
    }
}

sub read_msg {
    my ($self)=@_;
    my $flag=0;
    foreach ($self->adaptor->read_msg) {
	my ($from,$message,$target,$id)=@$_;
	$flag=$id;
	$self->{output}->insert('end',"\n$from:  to $target:  $message");
	my ($first,$last)=$self->{output}->Subwidget("yscrollbar")->get();
	if ($last>0.9) {
	    $self->{output}->yviewScroll(100,"units");
	}
    }
    $self->update;
    if ($flag) {   #only if some entries were found...
	$self->adaptor->msgindex($flag);    #update internal last id
	my ($first,$last)=$self->{output}->Subwidget("yscrollbar")->get();
	if ($last>0.9) {
	    $self->{output}->yviewScroll(100,"units");
	}
    }
    $self->update;
}


sub get_msg {
    my ($self)=@_;
    my $msg=$self->{input}->get("1.0","end");
    $msg =~ s/\n|\r/ /g;
    my $target=0;
    foreach (values %{$self->{target}}) {
	$target += $_ if $_;
    }
    if ($target) {
	$self->adaptor->take_msg($self,$msg);
	$self->read_msg;
	$self->{input}->delete("1.0",'end');
    } else {
	$self->{input}->insert('1.0',"You have to choose someone to talk to first.\n");
    }
}


1;





