

=head2 AUTHORS

Mark Wilkinson (mwilkinson@gene.pbi.nrc.ca)
Plant Biotechnology Institute, National Research Council of Canada.
Copyright (c) National Research Council of Canada, October, 2000.

=head2 DISCLAIMER

Anyone who intends to use and uses this software and code acknowledges and
agrees to the following: The National Research Council of Canada (herein "NRC")
disclaims any warranties, expressed, implied, or statutory, of any kind or
nature with respect to the software, including without limitation any warranty
or merchantability or fitness for a particular purpose.  NRC shall not be liable
in any event for any damages, whether direct or indirect,
consequential or incidental, arising from the use of the software.

=head2 SYNOPSIS



=head2 DESCRIPTION and ACKNOWLEDGEMENTS


=head2 CONTACT

Mark Wilkinson (mwilkinson@gene.pbi.nrc.ca)

=cut


package GQ::Client::annotMenuBrowser;

use strict;
use Tk;
use Tk::Text;
use Carp;
use vars qw($AUTOLOAD);
Tk::Widget->Construct('annotMenuBrowser');

# NOTE:  There is quite a bit of commenting-out of this code.  This is because I changed my mind
# about what it should do w.r.t. annotation.  I had thought that I should stick to the GO evidence
# codes, even for non-GO annotations, but then I thought better of it since this is supposed to be
# a very simplistic annotation tool.
# I left the code in as commented stuff just in case I ever change my mind.
#
#  												Mark

BEGIN {
    {
	#Encapsulated class data
	
	#___________________________________________________________
	#ATTRIBUTES
	my %_attr_data =	#     				DEFAULT    	ACCESSIBILITY
	  (	tagText 			=> [undef,			'read/write'], # the text box
		valueText 			=> [undef,			'read/write'], # the text box
		tag_value_path		=> ["./", 			'read/write'], # the path to the files, requires trailing slash.
		currentTag			=> [undef, 			'read/write'],
		currentValue		=> [undef, 			'read/write'],
		currentEvid			=> [undef, 			'read/write'],
		Submit				=> [undef, 			'read/write'], # the submit button
	  );

	#_____________________________________________________________
	#METHODS, to operate on encapsulated class data

	# Is a specified object attribute accessible in a given mode
	sub _accessible  {
	    my ($self, $attr, $mode) = @_;
	    $_attr_data{$attr}[1] =~ /$mode/
	}

	# Classwide default value for a specified object attribute
	sub _default_for {
	    my ($self, $attr) = @_;
	    $_attr_data{$attr}[0];
	}

	# List of names of all specified object attributes
	sub _standard_keys {
	    keys %_attr_data;
	}

	use subs (keys %_attr_data)

    }
} #end of BEGIN block

sub AUTOLOAD {
    no strict "refs";
    my ($self, $newval) = @_;

    $AUTOLOAD =~ /.*::(\w+)/;

    my $attr=$1;
    if ($self->_accessible($attr,'write')) {

	*{$AUTOLOAD} = sub {
	    if (defined $_[1]) { $_[0]->{$attr} = $_[1] }
	    return $_[0]->{$attr};
	};    ### end of created subroutine

###  this is called first time only
	if (defined $newval) {
	    $self->{$attr} = $newval
	}
	return $self->{$attr};

    } elsif ($self->_accessible($attr,'read')) {

	*{$AUTOLOAD} = sub {
	    return $_[0]->{$attr} }; ### end of created subroutine
	return $self->{$attr}  }


    # Must have been a mistake then...
    croak "No such method: $AUTOLOAD";
}


sub new{
	my ($caller, $mw, $QueryScreen, $Features, %args) = @_;
	my ($GO);
	return ref($mw) if ((ref($mw) ne "Tk::Toplevel"));
	return 0 if (!$Features);
	my @Features = @{$Features};
	
	my $caller_is_obj = ref($caller);
    my $class = $caller_is_obj || $caller;

    my $self = bless {}, $class;

    foreach my $attrname ( $self->_standard_keys ) {
    	if (exists $args{$attrname}) {
		$self->{$attrname} = $args{$attrname} }
    elsif ($caller_is_obj) {
		$self->{$attrname} = $caller->{$attrname} }
    else {
		$self->{$attrname} = $self->_default_for($attrname) }
    }
	
	$mw->configure(-title => "Tag/Value Browser");
	
	my $TopFrame =$mw->Frame(-background => "blue");
	my $BottomFrame =$mw->Frame(-background => "blue");
	my $left = $TopFrame->Frame(-background => "blue");
	my $mid = $TopFrame->Frame(-background => "blue");
	
	my $tagLabel = $left->Label(-text => "TAG",-background => "blue", -foreground => "white")->pack(-side => "top", -anchor => "center");
	my $valLabel = $mid->Label(-text => "VALUE",-background => "blue", -foreground => "white")->pack(-side => "top", -anchor => "center");
	
	my $TagText =      $left->Scrolled("Text", -width => 15, -height => 8, -wrap => "none", -background => "white")->pack(-side => "top", -anchor => "center");
	my $Tag2Text =      $left->Text(-width => 15, -height => 1, -wrap => "none", -background => "white")->pack(-side => "top", -anchor => "ne");
	my $ValueText =    $mid->Scrolled("Text", -width => 40, -height => 8, -wrap => "none", -background => "white")->pack(-side => "top", -anchor => "center");
	my $Value2Text =    $mid->Text(-width => 40, -height => 1, -background => "white")->pack(-side => "top", -anchor => "ne");
	
	$Value2Text->bind("<Key>" => sub {
						my $val = $Value2Text->get("1.0", "end");
						chomp ($val);
						$self->currentValue($val);
					});
	$Tag2Text->bind("<Key>" => sub {
						my $tag = $Tag2Text->get("1.0", "end");
						chomp ($tag);
						$tag =~ s/\W/_/g;
						$Tag2Text->delete("1.0", "end");
						$Tag2Text->insert("end", $tag);
						$self->currentTag($tag);
						
					});
	
	my $note_label = $BottomFrame->Label(-text => "de-novo tag/values may be entered in the spaces above.\nNew tags will become part of the restricted vocabulary.",
										 -foreground => "orange",
										 -background => "blue")->pack(
											 -side => "top",
											 -anchor => "center"
										);
	
	$self->Submit($BottomFrame->Button(-text => "Use Selected",
							-command => sub{
								my $tag = $self->currentTag;
								my $value = $self->currentValue;
								return if ((!$tag)||(!$value));  # if either are missing then get out
								my $newtag = $Tag2Text->get("1.0", "end");   # is this a new tag, or an existing tag
								chomp $newtag;                               # get rid of the newline character
								if ($newtag){$QueryScreen->context->create_tag($tag);} # put it into the database
								foreach my $Feature(@Features){
									$Feature->add_tag_value($tag, $value);
								}
								$self->{tagText}->destroy();
								$self->{valueText}->destroy();
								$self->Submit->eventGenerate("<<REFRESH>>"); # this is an awful hack to ensure that the txtHandannotate window reacts *after* the feature has been updated.
								$self->{COMPLETE} = 1;
							})
				)->pack(-side => "top", -anchor => "center");

	$left->pack(-side => "left", -expand => 1, -fill => "both");
	$mid->pack(-side => "left", -expand => 1, -fill => "both");
	$TopFrame->pack(-side => "top", -expand => 1, -fill => "both");
	$BottomFrame->pack(-side => "top", -expand => 1, -fill => "both");


	my @tags = $QueryScreen->context->get_tags;
	
	
	$self->tagText($TagText);
	$self->valueText($ValueText);
	
							
	open VALUE, "./Values.txt" or warn "the file Values.txt could not be found\nThis file should be together with the Genquire executables\n";
	my ($count);
	foreach my $tag(@tags){
		my $texttag;
		++$count; $texttag = "annot$count";  # need a unique single-work tag for each		
		chomp $tag;
		next if (!$tag);
		$TagText->insert("end", $tag, [$texttag]);
		$TagText->insert("end", "\n");
		$TagText->tagBind($texttag, "<Double-Button-1>",
			sub {
				$self->currentTag($tag);
				$TagText->Subwidget("text")->tagDelete("CHOSEN");
				$TagText->Subwidget("text")->tagAdd("CHOSEN", ($TagText->Subwidget("text")->tagRanges($texttag)));
				$TagText->tagConfigure("CHOSEN", -foreground => "red");
				$TagText->Subwidget("text")->tagDelete("sel");
				});		
	}
	while (my $value = <VALUE>){
		my $texttag;
		++$count; $texttag = "annot$count";
		chomp $value;
		next if (!$value);
		$ValueText->insert("end", $value, [$texttag]);
		$ValueText->insert("end", "\n");
		$ValueText->tagBind($texttag, "<Double-Button-1>",
			sub {
				$self->currentValue($value);
				$ValueText->Subwidget("text")->tagDelete("CHOSEN");
				$ValueText->Subwidget("text")->tagAdd("CHOSEN", ($ValueText->Subwidget("text")->tagRanges($texttag)));
				$ValueText->tagConfigure("CHOSEN", -foreground => "red");
				$ValueText->Subwidget("text")->tagDelete("sel");
				});
}
	close VALUE;

	$left->pack(-side => "left", -expand => 1, -fill => "both");
	$mid->pack(-side => "left", -expand => 1, -fill => "both");
	$TopFrame->pack(-side => "top", -expand => 1, -fill => "both");
	$BottomFrame->pack(-side => "top", -expand => 1, -fill => "both");

	$mw->waitVariable(\$self->{COMPLETE});

    return 1;                        # return handle to self
}


1;


