package GQ::Client::txtOutput;
use strict;
use Carp;
use Tk;
use vars qw( @ISA $AUTOLOAD );

#Tk::Widget->Construct('txtOutput');
#@ISA=qw(Tk::Text);

BEGIN {
    {
	my %_attr_data =	#     DEFAULT    ACCESSIBILITY
	  ( -exportselection => [1,         "read/write"],
	    -background      => ["#eeffff", "read/write"],
	    -foreground      => ["#000000", "read/write"],
	    -height          => [40,        "read/write"],
	    -width           => [80,        "read/write"],
	    -relief          => ["sunken",  "read/write"],
	    -takefocus       => [1,         "read/write"],
	    -wrap            => ['word',    "read/write"],
	    -scrollbars		=> ['se', 		"read/write"],
	    -tabs			=> [[qw/0.5c 1c/], 		"read/write"],
	    window          => [undef,     "read/write"],
	  );


	# Is a specified object attribute accessible in a given mode
	sub _accessible  {
	    my ($self, $attr, $mode) = @_;
	    return $_attr_data{$attr}[1] =~ /$mode/
	}

	# Classwide default value for a specified object attribute
	sub _default_for {
	    my ($self, $attr) = @_;
	    return $_attr_data{$attr}[0]
	}

	# List of names of all specified object attributes
	# A hash so names are not repeated
	sub _standard_keys { keys %_attr_data }

	use subs (keys %_attr_data)
    }
} #end of BEGIN block

sub new {
    my ($caller, $top, %args) = @_;
    my $caller_is_obj = ref($caller);
    my $class = $caller_is_obj || $caller;
    my $self=bless {},$class;

    foreach my $attrname ( $self->_standard_keys() ) {
    	if (exists $args{$attrname}) {
    	    $self->{$attrname} = $args{$attrname} }
    	elsif ($caller_is_obj) {
    	    $self->{$attrname} = $caller->{$attrname} }
    	else {
    	    $self->{$attrname} = $self->_default_for($attrname) }
    }

    foreach ($self->_standard_keys) {
	next if /window/;
	$args{$_}=$self->{$_};
    }
    $self->window($top->Scrolled('Text', %args)->pack(-side => 'top', -expand => '1', -fill => 'both' ));
    return $self;
}



sub DESTROY {}

sub AUTOLOAD {
    no strict "refs";
    my ($self, $newval) = @_;

    $AUTOLOAD =~ /.*::(\w+)/;

    my $attr=$1;
    if ($self->_accessible($attr,'write')) {

	*{$AUTOLOAD} = sub {
	    if (defined $_[1]) { $_[0]->{$attr} = $_[1] }
	    return $_[0]->{$attr};
	};    ### end of created subroutine

###  this is called first time only
	if (defined $newval) {
	    $self->{$attr} = $newval
	}
	return $self->{$attr};

    } elsif ($self->_accessible($attr,'read')) {

	*{$AUTOLOAD} = sub {
	    return $_[0]->{$attr} }; ### end of created subroutine
	return $self->{$attr}  }


    # Must have been a mistake then...
    croak "No such method: $AUTOLOAD";
}

1;


