#!/usr/bin/perl

# requires the PLUGINS folder, and the BioPerl folder
# EDIT THESE TWO LINES FOR YOUR INSTALLATION
use lib "/home/markw/OPEN_Genquire/Genquire/PLUGINS";
use lib "/home/markw/BIOPERL/bioperl/bioperl-live/";



# ________________________________________________________
use strict;
use Carp;
use GQ_comm;
use Bio::Tools::Genemark;
use Tk::DialogBox;


my $dbg = 0;  # set debug mode true or false
my $import;
my $source;
my $command = $ARGV[0];
my $TEMP = $ARGV[1];

use Tk;

sub log {
	return unless $dbg;
	open CHECK, ">/tmp/simpleoutputtt.txt" or die "can't open output file";
	print CHECK @_;
	close CHECK;
}


begin();
MainLoop;

sub begin {
	my $mw = MainWindow->new(-title => "GeneMarkHMM analysis");
	my $chkImport = $mw->Checkbutton(
		-text => "Import into Database",
		-variable =>\$import,
		-onvalue => 1,
		-offvalue => 0,
									);
	my $label = $mw->Label(-text => "enter a unique source tag\nfor these features");
	my $entry = $mw->Entry(
		-textvariable =>\$source,
						  );
	$source = "put unique tag here";
	my $btnBegin = $mw->Button(
		-text => "Begin GMHMM analysis of open contigs",
		-command => sub {&startOpenContigs($mw)},
							  );
	my $btnBegin2 = $mw->Button(
		-text => "Begin GMHMM analysis of ALL contigs",
		-command => sub {&startAllContigs($mw)},
							);
	$chkImport->pack(-side => "top");
	$label->pack(-side => 'top');
	$entry->pack(-side => 'top');
	$btnBegin->pack(-side => "top");
	$btnBegin2->pack(-side => "top");
	
}

sub startOpenContigs {
	my ($mw) = @_;
	return unless $source;
	my $result = &askGenquire("getActiveSequences", "");
	return unless ($result =~ /contig\sid/);
	&log("result1 $result\n\n");
	my @contigs = ($result =~ /(<contig.*?\/contig>)/g);
	foreach my $contigXML(@contigs){
		&log("contig1 $contigXML\n\n");
		my $contig = (($contigXML =~ /<contig id\=\'(.*?)\'>/) && $1);
		return unless $contig;
		my $seq = (($result =~ /<sequence>(.*?)<\/sequence>/) && $1);
		$seq =~ s/\W//g;
		return unless $seq;
		&log("sequence1 $seq\n\n");
		&log("output file:  >$TEMP/$contig\n\n");
		open OUT, ">$TEMP/$contig";
		print OUT ">$contig\n$seq\n";
		close OUT;
		system "gmhmme -o $TEMP/$contig.gmhmm $TEMP/$contig";
		unless (-e "$TEMP/$contig.gmhmm"){
			my $d = $mw->DialogBox(-title=>"GMHMM Failed", -default_button => "OK", -buttons => ["OK"]);
			$d->add('Label', -text => "GeneMarkHMM analysis failed.\nCheck your configuration and license expiry date")->pack;
			$d->Show;
			eval {unlink "$TEMP/$contig"};
			return 0;
		}
		my $Genemark = Bio::Tools::Genemark->new(-file => "$TEMP/$contig.gmhmm");
		while(my $gene = $Genemark->next_prediction()) {
			&log("got gene $gene");
			my @exons = $gene->exons();  # exons are FeatureI objects
			foreach my $exon(@exons){
				my $output = "<contig>$contig</contig>";
				my $strand = $exon->strand; unless (defined($strand)){$strand = "."}
				if ($strand eq "1"){$strand = "+"} # convert to GFF
				elsif ($strand eq "-1"){$strand = "-"}
				my $score = $exon->score; unless (defined($score)){$score = "."}
				my $frame = $exon->frame; unless (defined($frame)){$frame = "."}
				$output .="<start>".($exon->start)."</start>";
				$output .="<end>".($exon->end)."</end>";
				$output .="<feature>GeneMarkExon</feature>";
				$output .="<source>$source</source>";
				$output .="<strand>$strand</strand>";
				$output .="<frame>$frame</frame>";
				$output .="<score>$score</score>";
				$output .="<attributes></attributes>";
				$output = &checkImport($output);
				&log("output $output\n\n");
				&askGenquire("mapFeature", $output);
			}
		}
		$Genemark->close();
	}
}

sub checkImport {
	my ($message) = @_;
	if ($import){$message = "<import>$message</import>"}
	return $message;
}

	