# Feature::inMemory module for Workbench II

# by David Block <dblock@gene.pbir.nrc.ca>

# Copyright David Block and NRC-PBI

# POD Documentation - main docs before the code

=head1 NAME

Feature::inMemory - in Memory only Feature Object for Genquire

=head1 SYNOPSIS

=head2 Purpose of this class

The purpose of this class is to create a class of Features
that are available for temporary use, but are not written to the
database.

Otherwise, it inherits everything from the Feature class.

do perldoc Feature.pm

=head2 Creating a Feature::mod

use Feature::inMemory;

$feature2=Feature::inMemory->new(%$feature1);

This clones feature1, but does not write anything to the database about $feature2.

=head1 DESCRIPTION

Feature is a feature on a sequence. It follows the GFF format in
terms of how the data is stored.  Its start and stop values are relative to
Virtual Contigs, whose position is stored in the Tiling_Path table.

It is a GenericFeature, which means it implements Bio::SeqFeatureI as well as all
the (non-database) methods common to Feature, Gene, Feature::Annotation, and Feature::mod.

=head1 FEEDBACK

Like it or lump it, report to dblock@gene.pbi.nrc.ca.  Feel free to add
to the docs available at
http://bioinfo.pbi.nrc.ca/dblock/wiki

=head2 Reporting Bugs

Email the author with any bug reports.

=head1 AUTHOR - David Block

email dblock@gene.pbi.nrc.ca

=cut

package GQ::Server::Feature::inMemory;
$VERSION = 1.00;
use strict;

use vars qw( @ISA);  #Keep 'use strict' happy

use Carp;
use DBI;
use GQ::Root;

use GQ::Server::Feature;
@ISA = qw(GQ::Server::Feature);

{GQ::Root->create;}

### write in any custom subroutines here

sub _initialize {
    my ($self)=@_;
    $self->{access}='rw';
    return $self->SUPER::_initialize;
}

1;








