# MySQL dump 8.14
#
# Host: localhost    Database: Genquire version 3.4
#--------------------------------------------------------
# Server version	3.23.39-log
# #$Id: schema_v3.4.sql,v 1.1 2003/04/23 13:22:27 markw Exp $

#
# Table structure for table 'AnnotationLock'
#

CREATE TABLE AnnotationLock (
  user char(20) NOT NULL default '',
  version mediumint(8) unsigned NOT NULL default '0',
  assembly int(10) unsigned NOT NULL default '0',
  start int(10) unsigned NOT NULL default '0',
  stop int(10) unsigned NOT NULL default '0',
  id int(10) unsigned NOT NULL auto_increment,
  locked_when timestamp(14) NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

#
# Table structure for table 'Assembly'
#

CREATE TABLE Assembly (
  organism tinyint(3) unsigned default NULL,
  chr_id tinyint(3) unsigned default NULL,
  assembly_name varchar(30) default NULL,
  version int(10) unsigned default NULL,
  id int(10) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (id),
  UNIQUE KEY organism (organism,version,chr_id)
) TYPE=InnoDB;

#
# Table structure for table 'BlastAcc'
#

CREATE TABLE BlastAcc (
  id int(10) unsigned NOT NULL auto_increment,
  exon_id int(10) unsigned default NULL,
  gi varchar(20) default NULL,
  db varchar(10) default NULL,
  rawscore smallint(5) unsigned default NULL,
  probability double default NULL,
  accession text,
  description text,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

#
# Table structure for table 'BlastLookUp'
#

CREATE TABLE BlastLookUp (
  id1 int(10) unsigned NOT NULL default '0',
  id2 int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (id1,id2)
) TYPE=InnoDB;

#
# Table structure for table 'Blast_vs_EST'
#

CREATE TABLE Blast_vs_EST (
  id int(10) unsigned NOT NULL auto_increment,
  alignment varchar(20) default NULL,
  alignment_length varchar(20) default NULL,
  expect varchar(9) default NULL,
  score int(11) default NULL,
  num_hsp tinyint(4) default NULL,
  hsp_frac_conserved float default NULL,
  hsp_query_align_len int(11) default NULL,
  hsp_subj_align_len int(11) default NULL,
  hsp_query_gaps tinyint(4) default NULL,
  hsp_subj_gaps tinyint(4) default NULL,
  hsp_query_start int(11) default NULL,
  hsp_query_end int(11) default NULL,
  hsp_subj_start int(11) default NULL,
  hsp_subj_end int(11) default NULL,
  hsp_query_strand enum('f','r') default NULL,
  hsp_subj_strand enum('f','r') default NULL,
  hsp_frac_identical float default NULL,
  contig_id int(10) unsigned default NULL,
  source varchar(20) default NULL,
  PRIMARY KEY  (id),
  KEY contig_id (contig_id,alignment)
) TYPE=InnoDB;

#
# Table structure for table 'Chat'
#

CREATE TABLE Chat (
  user varchar(20) default NULL,
  message text,
  target text,
  id int(10) unsigned NOT NULL auto_increment,
  messagetime timestamp(14) NOT NULL,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

#
# Table structure for table 'Chat_user'
#

CREATE TABLE Chat_user (
  user char(30) default NULL,
  status enum('online','offline') default NULL,
  UNIQUE KEY user (user)
) TYPE=InnoDB;

#
# Table structure for table 'Container'
#

CREATE TABLE Container (
  parent int(10) unsigned NOT NULL default '0',
  element int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (parent,element),
  KEY element (element)
) TYPE=MyISAM;

#
# Table structure for table 'Contig'
#

CREATE TABLE Contig (
  id int(10) unsigned NOT NULL auto_increment,
  name char(30) NOT NULL default '',
  centromere enum('y','n') default 'n',
  PRIMARY KEY  (id),
  KEY name (name)
) TYPE=InnoDB;

#
# Table structure for table 'ContigAssembly'
#

CREATE TABLE ContigAssembly (
  contig_id int(10) unsigned NOT NULL default '0',
  version int(10) unsigned NOT NULL default '0',
  assembly int(10) unsigned NOT NULL default '0',
  id int(10) unsigned NOT NULL auto_increment,
  genbank_acc char(12) default NULL,
  PRIMARY KEY  (id),
  KEY assembly (assembly,contig_id)
) TYPE=InnoDB;

#
# Table structure for table 'Discard'
#

CREATE TABLE Discard (
  id varchar(20) default NULL,
  source_tag varchar(20) default NULL,
  primary_tag varchar(50) default NULL,
  contig_start int(10) unsigned default NULL,
  contig_stop int(10) unsigned default NULL,
  score mediumint(9) default NULL,
  strand enum('+','-','.') default NULL,
  frame enum('0','1','2','.') default NULL,
  length int(10) unsigned default NULL,
  last_modified datetime default NULL,
  modified_by varchar(25) default NULL,
  discarded_when timestamp(14) NOT NULL,
  discarded_whom varchar(25) default NULL,
  feature_id int(11) default NULL,
  idx int(10) unsigned NOT NULL auto_increment,
  contig_id int(10) unsigned default NULL,
  Tag int(10) unsigned default NULL,
  value text,
  parent int(10) unsigned default NULL,
  name varchar(30) default NULL,
  type varchar(30) default NULL,
  access enum('rw','ro') default NULL,
  PRIMARY KEY  (idx)
) TYPE=InnoDB;

#
# Table structure for table 'EST'
#

CREATE TABLE EST (
  id int(10) unsigned NOT NULL auto_increment,
  date timestamp(14) NOT NULL,
  gi mediumint(8) unsigned NOT NULL default '0',
  gb varchar(10) NOT NULL default '',
  description varchar(80) NOT NULL default '',
  seq text NOT NULL,
  source varchar(20) default NULL,
  PRIMARY KEY  (id),
  KEY gi (gi,gb)
) TYPE=InnoDB;

#
# Table structure for table 'Edit'
#

CREATE TABLE Edit (
  id int(10) unsigned NOT NULL default '0',
  last_modified timestamp(14) NOT NULL,
  modified_by varchar(25) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

#
# Table structure for table 'Feature'
#

CREATE TABLE Feature (
  id int(10) unsigned NOT NULL auto_increment,
  contig_id int(10) unsigned NOT NULL default '0',
  source_tag varchar(20) default NULL,
  primary_tag varchar(50) default NULL,
  contig_start int(10) unsigned default NULL,
  contig_stop int(10) unsigned default NULL,
  score mediumint(9) default NULL,
  strand enum('+','-','.') default NULL,
  frame enum('0','1','2','.') default NULL,
  length int(10) unsigned NOT NULL default '0',
  name varchar(30) default NULL,
  type int(10) unsigned NOT NULL default '1',
  access enum('rw','ro') default 'rw',
  PRIMARY KEY  (id),
  KEY primary_tag (primary_tag),
  KEY contig_id (contig_id,contig_start,contig_stop),
  KEY contig_start (contig_start,contig_stop),
  KEY contig_stop (contig_stop),
  KEY name (name)
) TYPE=InnoDB;

#
# Table structure for table 'FeatureType'
#

CREATE TABLE FeatureType (
  id int(10) unsigned NOT NULL auto_increment,
  type varchar(30) default NULL,
  container enum('Y','N') NOT NULL default 'N',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

#
# Table structure for table 'Flag'
#

CREATE TABLE Flag (
  id int(10) unsigned NOT NULL auto_increment,
  feature_id varchar(30) default NULL,
  flag int(10) unsigned NOT NULL default '0',
  contig_id int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=InnoDB;

#
# Table structure for table 'Flags'
#

CREATE TABLE Flags (
  id int(10) unsigned NOT NULL auto_increment,
  name char(30) default NULL,
  PRIMARY KEY  (id),
  KEY name (name)
) TYPE=InnoDB;

#
# Table structure for table 'GO_local'
#

CREATE TABLE GO_local (
  id int(10) unsigned NOT NULL default '0',
  term tinyblob,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

#
# Table structure for table 'Marker'
#

CREATE TABLE Marker (
  id int(10) unsigned NOT NULL auto_increment,
  contig_id int(10) unsigned default NULL,
  locus_name varchar(15) default NULL,
  locus_type enum('RFLP','AFLP','Gene','SNP') default NULL,
  contig_start int(10) unsigned default NULL,
  contig_stop int(10) unsigned default NULL,
  locus_source tinytext,
  PRIMARY KEY  (id)
) TYPE=InnoDB;

#
# Table structure for table 'Organism'
#

CREATE TABLE Organism (
  common char(20) default NULL,
  latin char(50) default NULL,
  id tinyint(3) unsigned NOT NULL default '0',
  code char(10) default NULL
) TYPE=MyISAM;

#
# Table structure for table 'Repeat_group'
#

CREATE TABLE Repeat_group (
  idx int(10) unsigned NOT NULL auto_increment,
  description text NOT NULL,
  base_seq text NOT NULL,
  PRIMARY KEY  (idx)
) TYPE=InnoDB;

#
# Table structure for table 'Repeat_region'
#

CREATE TABLE Repeat_region (
  idx int(10) unsigned NOT NULL auto_increment,
  group_id int(10) unsigned NOT NULL default '0',
  start int(10) unsigned NOT NULL default '0',
  length int(10) unsigned NOT NULL default '0',
  dir enum('+','-','.') default NULL,
  src varchar(20) default NULL,
  alignment text NOT NULL,
  extent enum('c','p') default NULL,
  chromosome int(10) unsigned NOT NULL default '0',
  contig varchar(25) NOT NULL default '',
  PRIMARY KEY  (idx),
  KEY contig (contig)
) TYPE=InnoDB;

#
# Table structure for table 'Sequence'
#

CREATE TABLE Sequence (
  contig_id int(10) unsigned NOT NULL default '0',
  seq mediumtext,
  PRIMARY KEY  (contig_id)
) TYPE=MyISAM;

#
# Table structure for table 'TagValue'
#

CREATE TABLE TagValue (
  id int(10) unsigned NOT NULL auto_increment,
  feature_id varchar(30) default NULL,
  tag int(10) unsigned default NULL,
  value text,
  parent int(10) unsigned default NULL,
  PRIMARY KEY  (id),
  KEY source_table (feature_id)
) TYPE=MyISAM;

#
# Table structure for table 'Tags'
#

CREATE TABLE Tags (
  id int(10) unsigned NOT NULL auto_increment,
  tag varchar(100) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=InnoDB;

#
# Table structure for table 'Tiling_Path'
#

CREATE TABLE Tiling_Path (
  contig_id int(10) unsigned NOT NULL default '0',
  abs_start int(10) unsigned default NULL,
  length int(10) unsigned default NULL,
  VC_start int(10) unsigned default NULL,
  VC_length int(10) unsigned default NULL,
  threeprime char(30) default NULL,
  overlap3 int(10) unsigned default NULL,
  fiveprime char(30) default NULL,
  overlap5 int(10) unsigned default NULL,
  PRIMARY KEY  (contig_id),
  KEY abs_start (abs_start,length)
) TYPE=InnoDB;

#
# Table structure for table 'Version'
#

CREATE TABLE Version (
  id int(10) unsigned NOT NULL default '0',
  label char(50) default NULL,
  organism mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (id,organism)
) TYPE=InnoDB;

#
# Table structure for table 'Word'
#

CREATE TABLE Word (
  id int(10) unsigned NOT NULL auto_increment,
  word varchar(100) default NULL,
  PRIMARY KEY  (id),
  UNIQUE KEY word (word)
) TYPE=InnoDB;

#
# Table structure for table 'WordBase'
#

CREATE TABLE WordBase (
  word int(10) unsigned NOT NULL default '0',
  fid int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (word,fid),
  KEY fid (fid)
) TYPE=InnoDB;

