#!/usr/bin/env python
#This function extract annotated information from KEGG databases
import sys
import os
cdp=os.getcwd()
#################################################
def help_fun():
	print('''
	This function extract annotated information from KEGG databases

	Command: ./camamed_kegg_annotation.py method [options]

	      method:
		  -h	Shows help related to this function
		  -pgc  Preparing the Gene Catalog for extracting annotated information from the KEGG databases.
			To obtain KOs associated with gene sequences using web services GhostKOALA and KAAS,
			it would be better if the file size of the gene catalog is less than 300 MB.
			The gene catalog is stored after the preprocessing and deletion of the duplicate genes (optional)
			named main_gene_catalog.fa in the CAMAMED folder of the program.
			If the gene catalog size is more than 300MB, you can use this option to convert it to smaller files.
			For example, if the gene catalog has 300 gene sequences,
			you can convert it to three files with 100 genes by entering the values 100 200.
			For Example: ./camamed_kegg_annotation.py -pgc 100 200

		  -egk  Extracting information from GhostKOALA or KAAS output files.
			In this step, the data of the files generated by GhostKOALA or KAAS server are read and the required information is extracted.
			To do this, first, copy the text files into CAMAMED/kegg_annotation and insert the filenames based on the example with space.
			Be sure to arrange the file names based on the gene number.
			For Example: ./camamed_kegg_annotation.py -egk gk_file1.txt gk_file2.txt

		  -kla  KEGG local anotation  
			We extracted all the annotated information related to the KOs and EC numbers and reactions to the date 2019/6/30.
			from the KEGG database and saved in the 'kegg_annotation' folder in the text files that start with the def prefix.
			At this step, we extract all the annotated information associated with the sequences step by step.
			For Example: ./camamed_kegg_annotation.py -kla
			
		  -kua  KEGG user annotation
			We extracted all the annotated information related to the KOs and EC numbers and reactions to the date 2019/6/30
			from the KEGG database and stored in the CAMAMED/kegg_annotation folder in the text files that start with the def prefix.
			But if you want to extract this information yourself, you can use these options.
			****These steps may take a long time****
			options:
			   -koec  Extract KO-related EC numbers from the KEGG database.
			   -ecre  Extract EC-related reactions from the KEGG database.
			   -reeq  Extract reaction-related equation from the KEGG database.
			For Example: ./camamed_kegg_annotation.py -kua -koec
				     ./camamed_kegg_annotation.py -kua -ecre
				     ./camamed_kegg_annotation.py -kua -reeq
	
	''')
#################################################
def ko_read3(text):
	url='http://www.genome.jp/dbget-bin/www_bfind_sub?mode=bfind&max_hit=1000&locale=en&serv=kegg&dbkey=orthology&keywords='+text
	f = urllib.request.urlopen(url)
	myfile = str(f.read())
	h1=myfile.find('style="margin-left:2em"> ')
	h2=myfile.find('[EC:')
	h3=h2
	if h3>-1:
		while myfile[h3]!=']':
			h3=h3+1
		st1=myfile[h2+4:h3]
	else:
		st1=""
	return st1
######################################end of ko_read() function
def ce_read3(text):
	url='http://www.genome.jp/dbget-bin/www_bget?ec:'+text
	f = urllib.request.urlopen(url)
	myfile =str(f.read())
	h1=myfile.find('Reaction(IUBMB)')
	h2=myfile.find('Reaction(KEGG)')
	st=myfile[h1:h2]
	return st
####################################end of ec_read() function
def ko_read2(text):
	url='http://www.genome.jp/dbget-bin/www_bfind_sub?mode=bfind&max_hit=1000&locale=en&serv=kegg&dbkey=orthology&keywords='+text
	f = urllib.urlopen(url)
	myfile = f.read()
	h1=myfile.find('style="margin-left:2em"> ')
	h2=myfile.find('[EC:')
	h3=h2
	if h3>-1:
		while myfile[h3]!=']':
			h3=h3+1
		st1=myfile[h2+4:h3]
	else:
		st1=""
	return st1
######################################end of ko_read() function
def ce_read2(text):
	url='http://www.genome.jp/dbget-bin/www_bget?ec:'+text
	f = urllib.urlopen(url)
	myfile = f.read()
	h1=myfile.find('Reaction(IUBMB)')
	h2=myfile.find('Reaction(KEGG)')
	st=myfile[h1:h2]
	return st
####################################end of ec_read() function
if not os.path.exists('sub_catalog_files'):
	os.mkdir('sub_catalog_files')
if len(sys.argv)<2:
	help_fun()
elif str(sys.argv[1])=='-h':
	help_fun()	
elif str(sys.argv[1])=='-pgc':
	if len(sys.argv)<3:
		print("Not enough input")
	else:
		file_p=cdp+'/files/catalog_length.txt'
		fcl=open(file_p,"r")
		cl=int(fcl.readline().rstrip('\n'))
		fcl.close()
		st=str(sys.argv[2])
		for i in range(3,len(sys.argv)):
			st=st+' '+str(sys.argv[i])
		x=[int(s) for s in st.split() if s.isdigit()]
		x=list(set(x))
		x.sort()
		f=0
		i=0
		while i<len(x):
			if x[i]<2 or x[i]>cl-1:
				f=1
			i+=1
		if f==1:
			print("syntax error")
			print("you must enter the sorted values regularly in range 2 and "+str(cl-1))
		else:
			file_p=cdp+'/main_gene_catalog.fa'
			fgc=open(file_p,"r")
			z=0
			for i in range(0,len(x)+1):
				if i==0:
					j=1
				else:
					j=x[i-1]+1
				if i<len(x):
					h=x[i]
				else:
					h=cl
				file_p=cdp+'/sub_catalog_files/catalog'+str(i+1)+'.fa'
				fsgc=open(file_p,"w")
				while j<=h:
					if z==0:
						text=fgc.readline().rstrip()
					if text!="" and text[0]=='>':
						z=1
						j+=1
						fsgc.write(text)
						fsgc.write('\n')
						text=fgc.readline().rstrip()
						while text!="" and text[0]!='>':
							fsgc.write(text)
							fsgc.write('\n')
							text=fgc.readline().rstrip()
					
				fsgc.close()
			print()
			print("The gene catalog has become "+str(len(x)+1)+" sub-catalogs and is stored in the sub_catalog_files folder.")
			print("You can repeat this step if their size is not appropriate.")
			print()
elif str(sys.argv[1])=='-egk':
	if len(sys.argv)<3:
		print("Not enough input")
	else:	
		import re
		import numpy		
		c=str(sys.argv[2])
		for i in range(3,len(sys.argv)):
			c=c+' '+str(sys.argv[i])
		h1=[m.start() for m in re.finditer(' ', c)]
		a=numpy.zeros(len(h1)+2)
		j=0
		while j<len(h1):
			a[j+1]=h1[j]
			j=j+1
		a[len(h1)+1]=len(c)
		b=a.astype(int)
		cdp=os.getcwd()
		file_p=cdp+'/kegg_annotation/gene_ko.txt'
		fgeko=open(file_p,"w")
		i=0
		while i<len(a)-1:
			if i==0:
				file_n=c[b[i]:b[i+1]]
			else:
				file_n=c[b[i]+1:b[i+1]]
			cdp=os.getcwd()
			file_p=cdp+'/kegg_annotation/'+file_n
			fkegg=open(file_p,"r")
			kl=fkegg.readline()
			while kl!="":
				h1=kl.find('\t')
				kkk=re.findall('K\d\d\d\d\d', kl)
				kk=[]
				j=0
				while j<len(kkk):
					if kkk[j] not in kk: 
						kk.append(kkk[j])
					j=j+1
				j=0
				while j<len(kk):
					fgeko.write(kl[0:h1]+'\t')
					fgeko.write(kk[j]+'\n')
					j=j+1
				kl=fkegg.readline()
			fkegg.close()
			i=i+1
		fgeko.close()
		############################
		file_p=cdp+'/kegg_annotation/gene_ko.txt'
		fgeko=open(file_p,"r")
		lko=[]
		x=fgeko.readline()
		while x!="":
			kk=re.findall('K\d\d\d\d\d', x)
			if kk not in lko: 
				lko.append(kk)
			x=fgeko.readline()
		fgeko.close()
		lko.sort()
		file_p=cdp+'/kegg_annotation/ko.txt'
		fko=open(file_p,"w")
		j=0
		while j<len(lko):
			str1 = ''.join(str(e) for e in lko[j])
			fko.write(str1+'\n')
			j=j+1
		fko.close()
		print()
		print("This information was successfully extracted.")
		print("The results are visible in the kegg_annotation folder in the gene_ko.txt and ko.txt files")
		print()
elif str(sys.argv[1])=='-kla':
	print("please wait...")
	print()
	print()
	file_p=cdp+'/kegg_annotation/gene_ko.txt'
	fgeko=open(file_p,"r")
	file_p=cdp+'/kegg_annotation/def_ko_ec.txt'
	fkoec=open(file_p,"r")
	file_p=cdp+'/kegg_annotation/gene_ec.txt'
	fgeec=open(file_p,"w")
	file_p=cdp+'/files/catalog_length.txt'
	fca=open(file_p,"r")
	clen=int(fca.readline().rstrip('\n'))
	fca.close()
	import re
	import numpy
	ge_ko_mat=numpy.zeros((clen,10), dtype=numpy.uint16)
	lko=[]
	lec=[]
	koec=fkoec.readline().rstrip('\n')
	while koec !="":
		h1=koec.find('\t')
		lko.append(koec[0:h1])
		lec.append(koec[h1+1:len(koec)])
		koec=fkoec.readline().rstrip('\n')
	lkoi=numpy.zeros((len(lko)),dtype=numpy.uint16)
	j=0
	while j<len(lko):
		s=lko[j];
		lkoi[j]=int(s[1:len(s)])
		j=j+1
	geko=fgeko.readline().rstrip('\n')
	while geko !="":
		h1=geko.find('\t')
		ge=int(geko[4:h1])
		ko=int(geko[h1+2:len(geko)])
		j=0
		while ge_ko_mat[ge-1][j]>0:
			j=j+1
		ge_ko_mat[ge-1][j]=ko
		geko=fgeko.readline().rstrip('\n')
		i=0;
	while i<clen:
		ec=[]
		j=0;
		while ge_ko_mat[i][j]>0:
			h1=numpy.where(lkoi==ge_ko_mat[i][j])
			h2=h1[0]
			#print(h2)
			if len(h2)>0 and lec[h2[0]] not in ec: 
				ec.append(lec[h2[0]])
			j=j+1	
		if len(ec)>0:
			ec.sort()
			j=0
			while j<len(ec):
				fgeec.write('gene'+str(i+1)+'\t')
				fgeec.write(ec[j]+'\n')
				j=j+1
		i+=1
	del ge_ko_mat
	del lko
	del lec
	del lkoi			
	fgeko.close()
	fkoec.close()
	fgeec.close()
	print("EC numbers related information was successfully extracted.")
	print("The results are visible in the kegg_annotation folder in the gene_ec.txt and def_ko_ec.txt and def_ec.txt files.")
	print()
	####################################################
	print("please wait...")
	print()
	print()
	file_p=cdp+'/kegg_annotation/gene_ec.txt'
	fgeec=open(file_p,"r")
	file_p=cdp+'/kegg_annotation/def_ec_re.txt'
	fecre=open(file_p,"r")
	file_p=cdp+'/kegg_annotation/gene_re.txt'
	fgere=open(file_p,"w")
	file_p=cdp+'/files/catalog_length.txt'
	fca=open(file_p,"r")
	clen=int(fca.readline().rstrip('\n'))
	fca.close()
	import re
	import numpy
	ge_ec_mat=numpy.zeros((clen,10), dtype=numpy.uint16)
	lec=[]
	lre=[]
	ecre=fecre.readline().rstrip('\n')
	while ecre !="":
		h1=ecre.find('\t')
		lec.append(ecre[0:h1])
		lre.append(ecre[h1+1:len(ecre)])
		ecre=fecre.readline().rstrip('\n')
	geec=fgeec.readline().rstrip('\n')
	while geec !="":
		h1=geec.find('\t')
		ge=int(geec[4:h1])
		ec=geec[h1+1:len(geec)-1]
		if ec in lec:
			h2=[index for index, value in enumerate(lec) if value == ec]
			if len(h2)>0:
				j=0
				f=0
				y=0
				while y<len(h2):
					while ge_ec_mat[ge-1][j]>0:
						if ge_ec_mat[ge-1][j]-1==h2[y]:
							f=1
						j=j+1
					if f==0:
						ge_ec_mat[ge-1][j]=h2[y]+1
					y+=1
		geec=fgeec.readline().rstrip('\n')
	i=0;
	while i<clen:
		re1=[]
		j=0;
		while ge_ec_mat[i][j]>0:
			re1.append(lre[ge_ec_mat[i][j]-1])
			j=j+1	
		if len(re1)>0:
			re1.sort()
			j=0
			while j<len(re1):
				fgere.write('gene'+str(i+1)+'\t')
				fgere.write(re1[j]+'\n')
				j=j+1
		i+=1
	del ge_ec_mat
	del lec
	del lre
	fgeec.close()
	fecre.close()
	fgere.close()
	print("Reactions related information was successfully extracted.")
	print("The results are visible in the kegg_annotation folder in the gene_re.txt and def_ec_re.txt and def_re.txt files.")
	print() 
	print("Finally, The reaction-related equations are visible in the kegg_annotation folder in the def_re_eq.txt file.")
	print()
###############################
elif str(sys.argv[1])=='-kua':
	if sys.version_info.major==3:
		import urllib.request
		if len(sys.argv)<3:
			print("Not enough input")
		elif str(sys.argv[2])=='-koec':
			os.system('clear')
			print("This step, extract KO-related EC numbers from the KEGG database.")
			print("To do this, have a file named ko.txt in the kegg_annotation folder. This file contains ko obtained for the sequence of genes from KEGG databases.")
			print() 
			print("Extract this KO-related EC numbers")
			cdp=os.getcwd()
			file_p=cdp+'/kegg_annotation/ko.txt'
			fko=open(file_p,"r")
			file_p=cdp+'/kegg_annotation/ko_ec.txt'
			fkoec=open(file_p,"w")
			file_p=cdp+'/kegg_annotation/ec.txt'
			fec=open(file_p,"w")
			lec=[]
			while 1:
				text=fko.readline().rstrip('\n')
				if text=="":
					break
				else:
					print(text)	
					st1=ko_read3(text)	
					if st1!="" and (' ' in st1)==False: 
						if ('-' in st1)==False:
							fkoec.write(text[0:6])
							fkoec.write('\t')	
							fkoec.write(st1)
							fkoec.write('\n')
							if st1 not in lec: 
								lec.append(st1)				
					elif st1!="" and (' ' in st1)==True:
						while st1!="":
							h1=st1.find(' ')
							if h1!=-1:
								st2=st1[0:h1]
							else:
								st2=st1
								st1=""
							#print(st2)
							st1=st1[h1+1:len(st1)]
							#print(st1)
							#input('ver=')
							if ('-' in st2)==False:
								fkoec.write(text[0:6])
								fkoec.write('\t')
								fkoec.write(st2)
								fkoec.write('\n')
								if st2 not in lec: 
									lec.append(st2)
			fko.close()
			fkoec.close()
			lec.sort()
			i=0
			while i<len(lec):
				fec.write(lec[i])
				fec.write('\n')
				i+=1
			fec.close()
			#####################################################
			file_p=cdp+'/kegg_annotation/gene_ko.txt'
			fgeko=open(file_p,"r")
			file_p=cdp+'/kegg_annotation/ko_ec.txt'
			fkoec=open(file_p,"r")
			file_p=cdp+'/kegg_annotation/gene_ec.txt'
			fgeec=open(file_p,"w")
			file_p=cdp+'/files/catalog_length.txt'
			fca=open(file_p,"r")
			clen=int(fca.readline().rstrip('\n'))
			fca.close()
			import re
			import numpy
			ge_ko_mat=numpy.zeros((clen,10), dtype=numpy.uint16)
			lko=[]
			lec=[]
			koec=fkoec.readline().rstrip('\n')
			while koec !="":
				h1=koec.find('\t')
				lko.append(koec[0:h1])
				lec.append(koec[h1+1:len(koec)])
				koec=fkoec.readline().rstrip('\n')
			lkoi=numpy.zeros((len(lko)),dtype=numpy.uint16)
			j=0
			while j<len(lko):
				s=lko[j];
				lkoi[j]=int(s[1:len(s)])
				j=j+1
			geko=fgeko.readline().rstrip('\n')
			while geko !="":
				h1=geko.find('\t')
				ge=int(geko[4:h1])
				ko=int(geko[h1+2:len(geko)])
				j=0
				while ge_ko_mat[ge-1][j]>0:
					j=j+1
				ge_ko_mat[ge-1][j]=ko
				geko=fgeko.readline().rstrip('\n')
	
			i=0;
			while i<clen:
				ec=[]
				j=0;
				while ge_ko_mat[i][j]>0:
					h1=numpy.where(lkoi==ge_ko_mat[i][j])
					h2=h1[0]
					#print(h2)
					if len(h2)>0 and lec[h2[0]] not in ec: 
						ec.append(lec[h2[0]])
					j=j+1	
				if len(ec)>0:
					ec.sort()
					j=0
					while j<len(ec):
						fgeec.write('gene'+str(i+1)+'\t')
						fgeec.write(ec[j]+'\n')
						j=j+1
				i+=1
			del ge_ko_mat
			del lko
			del lec
			del lkoi			
			fgeko.close()
			fkoec.close()
			fgeec.close()
	
			print("This information was successfully extracted.")
			print("The results are visible in the kegg_annotation folder in the gene_ec.txt and ko_ec.txt and ec.txt files")
		elif str(sys.argv[2])=='-ecre':
			os.system('clear')
			print("This step, optain EC-related reactions from the KEGG database.")
			print("To do this, have a file named ec.txt in the kegg_annotation folder. This file contains EC numbers extracted for the KO numbers from KEGG databases.")	
			print() 
			print("Extract this EC numbers-related reactions")
			cdp=os.getcwd()
			file_p=cdp+'/kegg_annotation/ec.txt'
			fec=open(file_p,"r")
			file_p=cdp+'/kegg_annotation/ec_re.txt'
			fecre=open(file_p,"w")
			file_p=cdp+'/kegg_annotation/re.txt'
			fre=open(file_p,"w")
			lre=[]
			while 1:
				text=fec.readline().rstrip('\n')
				if text=="":
					break
				else:
					print(text)
					st=ce_read3(text)		
					h3=st.find('href="/dbget-bin/www_bget?rn:')
					while h3>-1:
						fecre.write(text)
						fecre.write('\t')	
						fecre.write(st[h3+29:h3+35])
						fecre.write('\n')
						if st[h3+29:h3+35] not in lre: 
							lre.append(st[h3+29:h3+35])
						st=st[h3+35:len(st)]	
						h3=st.find('href="/dbget-bin/www_bget?rn:')
			fec.close()
			fecre.close()
			lre.sort()
			i=0
			while i<len(lre):
				fre.write(lre[i])
				fre.write('\n')
				i+=1
			fre.close()
			#####################################################
			file_p=cdp+'/kegg_annotation/gene_ec.txt'
			fgeec=open(file_p,"r")
			file_p=cdp+'/kegg_annotation/ec_re.txt'
			fecre=open(file_p,"r")
			file_p=cdp+'/kegg_annotation/gene_re.txt'
			fgere=open(file_p,"w")
			file_p=cdp+'/files/catalog_length.txt'
			fca=open(file_p,"r")
			clen=int(fca.readline().rstrip('\n'))
			fca.close()
			import re
			import numpy
			ge_ec_mat=numpy.zeros((clen,10), dtype=numpy.uint16)
			lec=[]
			lre=[]
			ecre=fecre.readline().rstrip('\n')
			while ecre !="":
				h1=ecre.find('\t')
				lec.append(ecre[0:h1])
				lre.append(ecre[h1+1:len(ecre)])
				ecre=fecre.readline().rstrip('\n')
			geec=fgeec.readline().rstrip('\n')
			while geec !="":
				h1=geec.find('\t')
				ge=int(geec[4:h1])
				ec=geec[h1+1:len(geec)]
				if ec in lec:
					h2=[index for index, value in enumerate(lec) if value == ec]
					if len(h2)>0:
						j=0
						f=0
						y=0
						while y<len(h2):
							while ge_ec_mat[ge-1][j]>0:
								if ge_ec_mat[ge-1][j]-1==h2[y]:
									f=1
								j=j+1
							if f==0:
								ge_ec_mat[ge-1][j]=h2[y]+1
							y+=1
				geec=fgeec.readline().rstrip('\n')
			i=0;
			while i<clen:
				re1=[]
				j=0;
				while ge_ec_mat[i][j]>0:
					re1.append(lre[ge_ec_mat[i][j]-1])
					j=j+1	
				if len(re1)>0:
					re1.sort()
					j=0
					while j<len(re1):
						fgere.write('gene'+str(i+1)+'\t')
						fgere.write(re1[j]+'\n')
						j=j+1
				i+=1
			del ge_ec_mat
			del lec
			del lre
			fgeec.close()
			fecre.close()
			fgere.close()
	
			print("This information was successfully extracted.")
			print("The results are visible in the kegg_annotation folder in the gene_re.txt and ec_re.txt and re.txt files")
		elif str(sys.argv[2])=='-reeq':
			os.system('clear')
			print("This step, extract reaction-related equations from the KEGG database.")
			print("To do this, have a file named re.txt in the kegg_annotation folder. This file contains reaction numbers extracted from KEGG databases.")	
			print() 
			print("Extract this reactions-related equation")
			cdp=os.getcwd()
			file_p=cdp+'/kegg_annotation/re.txt'
			fre=open(file_p,"r")
			file_p=cdp+'/kegg_annotation/re_eq.txt'
			freeq=open(file_p,"w")
			while 1:
				text=fre.readline().rstrip('\n')
				if text=="":
					break
				else:
					print(text)		
					url='http://www.genome.jp/dbget-bin/www_bget?rn:'+text
					f = urllib.request.urlopen(url)
					myfile =str(f.read())
					h1=myfile.find('Definition')
					h1=h1+236
					h2=h1
					while myfile[h2+1]!='<':
						h2=h2+1;
					freeq.write('Reaction:'+text+'\t')
					s=myfile[h1:h2+1].replace("&lt;=&gt;", "<=>")
					freeq.write('Definition:'+s+'\t')
					h1=myfile.find('Equation')
					h1=h1+175
					import re
					h3=[m.start() for m in re.finditer('<br>', myfile)]
					j=0
					while h3[j]<h1:
						j=j+1
					h2=h3[j]-1
					st=myfile[h1:h2].replace("&lt;=&gt;", "<=>")
					freeq.write('Equation:')
					h1=[m.start() for m in re.finditer('<a href="/dbget-bin/www_bget?',st)]
					h3=st.find('<=>')
					j=0
					while h1[j]<h3:
						if j==0:
							ss=st[h1[j]+41:h1[j]+47]+'+'
						else:
							ss=ss+st[h1[j]+41:h1[j]+47]+'+'
						j=j+1	
					ss=ss+"<=>"
					while j<len(h1)-1:
						ss=ss+st[h1[j]+41:h1[j]+47]+'+'
						j=j+1
					ss=ss+st[h1[j]+41:h1[j]+47]
					s=ss.replace("+<=>", " <=> ")
					freeq.write(s)
					freeq.write('\n')
			fre.close()
			freeq.close()
			print("This information was successfully extracted.")
			print("The results are visible in the kegg_annotation folder in the re_eq.txt file.")
		else:
			help_fun()
	elif sys.version_info.major==2:
		import urllib
		if len(sys.argv)<3:
			print("Not enough input")
		elif str(sys.argv[2])=='-koec':
			os.system('clear')
			print("This step, extract KO-related EC numbers from the KEGG database.")
			print("To do this, have a file named ko.txt in the kegg_annotation folder. This file contains ko obtained for the sequence of genes from KEGG databases.")
			print()
			print("Extract this KO-related EC numbers")
			cdp=os.getcwd()
			file_p=cdp+'/kegg_annotation/ko.txt'
			fko=open(file_p,"r")
			file_p=cdp+'/kegg_annotation/ko_ec.txt'
			fkoec=open(file_p,"w")
			file_p=cdp+'/kegg_annotation/ec.txt'
			fec=open(file_p,"w")
			lec=[]
			while 1:
				text=fko.readline().rstrip('\n')
				if text=="":
					break
				else:
					print(text)	
					st1=ko_read2(text)	
					if st1!="" and (' ' in st1)==False: 
						if ('-' in st1)==False:
							fkoec.write(text[0:6])
							fkoec.write('\t')	
							fkoec.write(st1)
							fkoec.write('\n')
							if st1 not in lec: 
								lec.append(st1)				
					elif st1!="" and (' ' in st1)==True:
						while st1!="":
							h1=st1.find(' ')
							if h1!=-1:
								st2=st1[0:h1]
							else:
								st2=st1
								st1=""
							#print(st2)
							st1=st1[h1+1:len(st1)]
							#print(st1)
							#input('ver=')
							if ('-' in st2)==False:
								fkoec.write(text[0:6])
								fkoec.write('\t')
								fkoec.write(st2)
								fkoec.write('\n')
								if st2 not in lec: 
									lec.append(st2)
			fko.close()
			fkoec.close()
			lec.sort()
			i=0
			while i<len(lec):
				fec.write(lec[i])
				fec.write('\n')
				i+=1
			fec.close()
			#####################################################
			file_p=cdp+'/kegg_annotation/gene_ko.txt'
			fgeko=open(file_p,"r")
			file_p=cdp+'/kegg_annotation/ko_ec.txt'
			fkoec=open(file_p,"r")
			file_p=cdp+'/kegg_annotation/gene_ec.txt'
			fgeec=open(file_p,"w")
			file_p=cdp+'/files/catalog_length.txt'
			fca=open(file_p,"r")
			clen=int(fca.readline().rstrip('\n'))
			fca.close()
			import re
			import numpy
			ge_ko_mat=numpy.zeros((clen,10), dtype=numpy.uint16)
			lko=[]
			lec=[]
			koec=fkoec.readline().rstrip('\n')
			while koec !="":
				h1=koec.find('\t')
				lko.append(koec[0:h1])
				lec.append(koec[h1+1:len(koec)])
				koec=fkoec.readline().rstrip('\n')
			lkoi=numpy.zeros((len(lko)),dtype=numpy.uint16)
			j=0
			while j<len(lko):
				s=lko[j];
				lkoi[j]=int(s[1:len(s)])
				j=j+1
			geko=fgeko.readline().rstrip('\n')
			while geko !="":
				h1=geko.find('\t')
				ge=int(geko[4:h1])
				ko=int(geko[h1+2:len(geko)])
				j=0
				while ge_ko_mat[ge-1][j]>0:
					j=j+1
				ge_ko_mat[ge-1][j]=ko
				geko=fgeko.readline().rstrip('\n')
	
			i=0;
			while i<clen:
				ec=[]
				j=0;
				while ge_ko_mat[i][j]>0:
					h1=numpy.where(lkoi==ge_ko_mat[i][j])
					h2=h1[0]
					#print(h2)
					if len(h2)>0 and lec[h2[0]] not in ec: 
						ec.append(lec[h2[0]])
					j=j+1	
				if len(ec)>0:
					ec.sort()
					j=0
					while j<len(ec):
						fgeec.write('gene'+str(i+1)+'\t')
						fgeec.write(ec[j]+'\n')
						j=j+1
				i+=1
			del ge_ko_mat
			del lko
			del lec
			del lkoi			
			fgeko.close()
			fkoec.close()
			fgeec.close()
	
			print("This information was successfully extracted.")
			print("The results are visible in the kegg_annotation folder in the gene_ec.txt and ko_ec.txt and ec.txt files")
		elif str(sys.argv[2])=='-ecre':
			os.system('clear')
			print("This step, optain EC-related reactions from the KEGG database.")
			print("To do this, have a file named ec.txt in the kegg_annotation folder. This file contains EC numbers extracted for the KO numbers from KEGG databases.")
			print()
			print("Extract this EC numbers-related reactions")
			import urllib
			cdp=os.getcwd()
			file_p=cdp+'/kegg_annotation/ec.txt'
			fec=open(file_p,"r")
			file_p=cdp+'/kegg_annotation/ec_re.txt'
			fecre=open(file_p,"w")
			file_p=cdp+'/kegg_annotation/re.txt'
			fre=open(file_p,"w")
			lre=[]
			while 1:
				text=fec.readline().rstrip('\n')
				if text=="":
					break
				else:
					print(text)
					st=ce_read2(text)		
					h3=st.find('href="/dbget-bin/www_bget?rn:')
					while h3>-1:
						fecre.write(text)
						fecre.write('\t')	
						fecre.write(st[h3+29:h3+35])
						fecre.write('\n')
						if st[h3+29:h3+35] not in lre: 
							lre.append(st[h3+29:h3+35])
						st=st[h3+35:len(st)]	
						h3=st.find('href="/dbget-bin/www_bget?rn:')
			fec.close()
			fecre.close()
			lre.sort()
			i=0
			while i<len(lre):
				fre.write(lre[i])
				fre.write('\n')
				i+=1
			fre.close()
			#####################################################
			file_p=cdp+'/kegg_annotation/gene_ec.txt'
			fgeec=open(file_p,"r")
			file_p=cdp+'/kegg_annotation/ec_re.txt'
			fecre=open(file_p,"r")
			file_p=cdp+'/kegg_annotation/gene_re.txt'
			fgere=open(file_p,"w")
			file_p=cdp+'/files/catalog_length.txt'
			fca=open(file_p,"r")
			clen=int(fca.readline().rstrip('\n'))
			fca.close()
			import re
			import numpy
			ge_ec_mat=numpy.zeros((clen,10), dtype=numpy.uint16)
			lec=[]
			lre=[]
			ecre=fecre.readline().rstrip('\n')
			while ecre !="":
				h1=ecre.find('\t')
				lec.append(ecre[0:h1])
				lre.append(ecre[h1+1:len(ecre)])
				ecre=fecre.readline().rstrip('\n')
			geec=fgeec.readline().rstrip('\n')
			while geec !="":
				h1=geec.find('\t')
				ge=int(geec[4:h1])
				ec=geec[h1+1:len(geec)]
				if ec in lec:
					h2=[index for index, value in enumerate(lec) if value == ec]
					if len(h2)>0:
						j=0
						f=0
						y=0
						while y<len(h2):
							while ge_ec_mat[ge-1][j]>0:
								if ge_ec_mat[ge-1][j]-1==h2[y]:
									f=1
								j=j+1
							if f==0:
								ge_ec_mat[ge-1][j]=h2[y]+1
							y+=1
				geec=fgeec.readline().rstrip('\n')
			i=0;
			while i<clen:
				re1=[]
				j=0;
				while ge_ec_mat[i][j]>0:
					re1.append(lre[ge_ec_mat[i][j]-1])
					j=j+1	
				if len(re1)>0:
					re1.sort()
					j=0
					while j<len(re1):
						fgere.write('gene'+str(i+1)+'\t')
						fgere.write(re1[j]+'\n')
						j=j+1
				i+=1
			del ge_ec_mat
			del lec
			del lre
			fgeec.close()
			fecre.close()
			fgere.close()
	
			print("This information was successfully extracted.")
			print("The results are visible in the kegg_annotation folder in the gene_re.txt and ec_re.txt and re.txt files")
		elif str(sys.argv[2])=='-reeq':
			os.system('clear')
			print("This step, extract reaction-related equations from the KEGG database.")
			print("To do this, have a file named re.txt in the kegg_annotation folder. This file contains reaction numbers extracted from KEGG databases.")
			print()
			print("Extract this reactions-related equation")
			import urllib
			cdp=os.getcwd()
			file_p=cdp+'/kegg_annotation/re.txt'
			fre=open(file_p,"r")
			file_p=cdp+'/kegg_annotation/re_eq.txt'
			freeq=open(file_p,"w")
			while 1:
				text=fre.readline().rstrip('\n')
				if text=="":
					break
				else:
					print(text)		
					url='http://www.genome.jp/dbget-bin/www_bget?rn:'+text
					f = urllib.urlopen(url)
					myfile = f.read()
					h1=myfile.find('Definition')
					h1=h1+236
					h2=h1
					while myfile[h2+1]!='<':
						h2=h2+1;
					freeq.write('Reaction:'+text+'\t')
					s=myfile[h1:h2+1].replace("&lt;=&gt;", "<=>")
					freeq.write('Definition:'+s+'\t')
					h1=myfile.find('Equation')
					h1=h1+175
					import re
					h3=[m.start() for m in re.finditer('<br>', myfile)]
					j=0
					while h3[j]<h1:
						j=j+1
					h2=h3[j]-1
					st=myfile[h1:h2].replace("&lt;=&gt;", "<=>")
					freeq.write('Equation:')
					h1=[m.start() for m in re.finditer('<a href="/dbget-bin/www_bget?',st)]
					h3=st.find('<=>')
					j=0
					while h1[j]<h3:
						if j==0:
							ss=st[h1[j]+41:h1[j]+47]+'+'
						else:
							ss=ss+st[h1[j]+41:h1[j]+47]+'+'
						j=j+1	
					ss=ss+"<=>"
					while j<len(h1)-1:
						ss=ss+st[h1[j]+41:h1[j]+47]+'+'
						j=j+1
					ss=ss+st[h1[j]+41:h1[j]+47]
					s=ss.replace("+<=>", " <=> ")
					freeq.write(s)
					freeq.write('\n')
			fre.close()
			freeq.close()
			print("This information was successfully extracted.")
			print("The results are visible in the kegg_annotation folder in the re_eq.txt file.")
		else:
			help_fun()
else:	
	help_fun()