#!/usr/bin/env python
#This function executes Metaphlan2 software on sample data
import sys
import os
cdp=os.getcwd()
#################################################
def help_fun():
	print('''
	In this function, using the Metaphlan2 software extract the abundance of all bacteria.
	Metaphlan2 can produce taxonomic profiling at different levels.
	Such as Kingdom, Phylum, Class, Order, Family, Genus, and Species.

	Command: ./camamed_metaphlan_profiling.py method [options]

	      method:
		  -h	Shows help related to this function.
		  -mph  Execute metaphlan2.
			options:
			    -tl (taxa_level): For selecting Kingdom, Phylum, Class, Order, Family, Genus, or Species,
			    Select one of {'k', 'p', 'c', 'o', 'f', 'g', 's'}
			    -c (core_number): select number of cores for Metaphlan2 execution (default=1).
			    The number of cores must be a positive integer, otherwise one is chosen.
			For Example: ./camamed_metaphlan_profiling.py -mph -tl s -c 3		

		  -imp  Extract information from metaphlan2 output files.
			For Example: ./camamed_metaphlan_profiling.py -imp

	''')
#################################################
if not os.path.exists('metaphlan_output'):
	os.mkdir('metaphlan_output')
if len(sys.argv)<2:
	help_fun()
elif str(sys.argv[1])=='-h':
	help_fun()
elif str(sys.argv[1])=='-mph':
	if len(sys.argv)<4:
		print("Not enough input")
	else:
		sf=0
		sk=0
		ss=sys.argv
		try:
			i = ss.index('-tl')
		except ValueError:
			i=-1
			print("syntax error")
		if i+1<len(sys.argv) and i!=-1:
			sf=1
			c=str(sys.argv[i+1])
			if c not in ['k','p','c','o','f','g','s']:
				sf=0
				print("Selected character is not correct, enter one of {'k','p','c','o','f','g','s'}")
		co=1
		if len(sys.argv)>4:
			try:
				i = ss.index('-c')
			except ValueError:
				i=-1
				print("syntax error")
				sk=1
			if i+1<len(sys.argv) and i!=-1:
				co=int(sys.argv[i+1])
		if sf==1 and sk==0:
			import subprocess
			cmd1 = './metaphlan_samlpe.sh '+c+' '+str(co)
			subprocess.call(cmd1, shell=True)
elif str(sys.argv[1])=='-imp':
	os.system('clear')
	cdp=os.getcwd()
	print("In this step, the data of the files generated by metaphlan is read and the required information is extracted.")
	file_p=cdp+'/Read_files/'+'sample_file_names.txt'
	sam_na=open(file_p,"r")
	file_p=cdp+'/all_results/'+'total_metaphlan_results.txt'
	fmp=open(file_p,"w")
	taxa=[]
	sac=0
	while 1:
		san=sam_na.readline().rstrip()
		if san=="":
			break
		else:
			sac=sac+1
			file_p=cdp+'/metaphlan_output/metaphlan_'+san
			ftx=open(file_p,"r")
			tx=ftx.readline()
			tx=ftx.readline()
			while tx !="":
				tl=tx[0]
				h1=tx.find('\t')
				tx1=tx[3:h1]
				if tx1 not in taxa: 
					taxa.append(tx1)
				tx=ftx.readline()
			ftx.close()
	sam_na.close()		
	taxa.sort()
	file_p=cdp+'/all_results/'+'metaphlan_taxa.txt'
	fmtx=open(file_p,"w")
	cmd1 = 'Bacteria in '+tl+' level extracted with Metaphlan2'
	fmtx.write(cmd1)
	fmtx.write('\n')
	j=0
	while j<len(taxa):
		fmtx.write(taxa[j])
		fmtx.write('\n')
		j=j+1
	fmtx.close()
	###########################
	file_p=cdp+'/Read_files/'+'sample_file_names.txt'
	sam_na=open(file_p,"r")
	s=(len(taxa),sac)
	import numpy
	meta_mat=numpy.zeros(s)
	j=-1
	while 1:
		san=sam_na.readline().rstrip()
		if san=="":
			break
		else:
			j=j+1
			file_p=cdp+'/metaphlan_output/metaphlan_'+san
			ftx=open(file_p,"r")
			tx=ftx.readline()
			tx=ftx.readline()
			while tx !="":
				h1=tx.find('\t')
				tx1=tx[3:h1]
				c1=tx[h1+1:len(tx)]
				i=taxa.index(tx1)
				meta_mat[i,j]=c1
				tx=ftx.readline()
			ftx.close()
	sam_na.close()
	if tl=='k':
		tll="Kingdom"
	elif tl=='p':
		tll="Phylum"
	elif tl=='c':
		tll="Class"
	elif tl=='o':
		tll="Order"
	elif tl=='f':
		tll="Family"
	elif tl=='g':
		tll="Genus"
	elif tl=='s':
		tll="Species"
	fmp.write("This file shows the results of Metaphlan on all samples, which are presented in the level of the "+tll+" in taxonomic profiling\n")
	fmp.write("Columns The name of the samples and rows is the name of the bacteria in the taxonomic level\n")
	file_p=cdp+'/Read_files/'+'sample_file_names.txt'
	sam_na=open(file_p,"r")
	fmp.write('                                ')
	while 1:
		san=sam_na.readline().rstrip()
		if san=="":
			break
		else:
			fmp.write('%15s'%san)
			fmp.write('\t')
	fmp.write('\n')
	sam_na.close()
	i=0
	while i<len(taxa):
		fmp.write('%-28s'%taxa[i])
		fmp.write('\t')
		j=0
		while j<sac:
			fmp.write('%15s'%str(meta_mat[i,j]))
			fmp.write('\t')
			j=j+1
		fmp.write('\n')
		i=i+1
	fmp.close()
	print
	print		
	print("This information was successfully extracted.")
	print("The results are visible in the all_results folder in the metaphlan_taxa.txt and total_metaphan_results.txt files.")
else:
	help_fun()
