 function E = Evaluate(ACTUAL1,PREDICTED1)
% This fucntion evaluates the performance of a classification model by 
% calculating the common performance measures: Accuracy, Sensitivity, 
% Specificity, Precision, Recall, F-Measure, G-mean.
% Input: ACTUAL = Column matrix with actual class labels of the training
%                 examples
%        PREDICTED = Column matrix with predicted class labels by the
%                    classification model
% Output: EVAL = Row matrix with all the performance measures
a=unique(ACTUAL1);
EVAL=[0 0 0 0 0 0];
for i=1:length(a)
    ACTUAL=ACTUAL1;
    PREDICTED=PREDICTED1;
    for j=1:length(ACTUAL)
        if ACTUAL(j)==i
            ACTUAL(j)=1;
        else
            ACTUAL(j)=0;
        end
        if PREDICTED(j)==i
            PREDICTED(j)=1;
        else
            PREDICTED(j)=0;
        end
    end

    idx = (ACTUAL()==1);
    p = length(ACTUAL(idx));
    n = length(ACTUAL(~idx));
    N = p+n;
    tp = sum(ACTUAL(idx)==PREDICTED(idx));
    tn = sum(ACTUAL(~idx)==PREDICTED(~idx));
    fp = n-tn;
    fn = p-tp;
    
    tp_rate = tp/p;
    tn_rate = tn/n;
    
    accuracy = (tp+tn)/N;
    sensitivity = tp_rate;
    specificity = tn_rate;
    precision = tp/(tp+fp);
    if isnan(precision)==1
        precision=0;
    end
    recall = sensitivity;
    f_measure = 2*((precision*recall)/(precision + recall));
    if isnan(f_measure)==1
        f_measure=0;
    end
    gmean = sqrt(tp_rate*tn_rate);
    
    EVAL =EVAL+ [accuracy sensitivity specificity precision f_measure gmean];
end
%disp('accuracy sensitivity specificity precision f_measure gmean');
EVAL=EVAL/(length(a));
E=EVAL(1:3);