function cross_validation_svm(data,label,n,k)
%this function N repeats K fold cross-validation and SVM classification 
% data: a data set n x d   (n: number of samples, d number of features)
%label : label of samples  n x 1
%n number of repetation of K fold cross-validation
%k number of cross-validation fold
warning off;
h=1;
for i=1:n
    disp('repeat=');
    disp(i)
    c = cvpartition(label,'KFold',k);
    for j=1:k
        t1=find(gather(c.test(j))==1);
        t2=find(gather(c.training(j))==1);
        train_data=data(t1,:);
        test_data=data(t2,:);
        train_la=label(t1);
        test_la=label(t2);
		result = multisvm(train_data,train_la,test_data);
        e(h,1:3) = Evaluate(test_la,result);
		e(h,4)=mean(colAUC(result,test_la'));
        h=h+1;
    end
end
disp('accuracy sensitivity specificity AUC');
E=mean(e)

