#!/usr/bin/perl

#this program corrects for a bug in ESTScan

use strict;
use File::Copy;

my $escanLocation = `which ESTScan`;

chomp $escanLocation;
if ($escanLocation)	{
	print "Found ESTScan at $escanLocation - good\n\n";
}
else	{
	print "ERROR: Cannot find ESTScan! Is it installed?\nAny problems please email me at: nematode.bioinf\@ed.ac.uk\n";
	exit;
}
if (my $file=readlink($escanLocation))	{ 
	$escanLocation=$file;
}

$escanLocation=~s/\/ESTScan$//;
unless (-W $escanLocation)	{
	print "Error you do not have permission to change the file\nPerhaps you need to be logged in as root\nAny problems please email me at: nematode.bioinf\@ed.ac.uk\n";
	exit;
}

open IN, "<$escanLocation/ESTScan";
open OUT, ">$escanLocation/ESTScan_tmp";

while (my $line = <IN>)	{
	$line=~s/(\$pSeq =~ s\/\[acgt)(\]\/\/g)/\1n\2/;
	print OUT $line;
}
move("$escanLocation/ESTScan_tmp","$escanLocation/ESTScan");
chmod 0755, "$escanLocation/ESTScan";
print "ESTScan now fixed\n";
