/**************************************************************************
 * This code is part of the supporting infrastructure for ATA Mapper. 
 * Copyright (C) 2002,2003,2004 Applera Corporation. All rights reserved.
 * Author: Nathan Edwards
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received (LICENSE.txt) a copy of the GNU General Public 
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *************************************************************************/

#ifndef _IBPEP_FASTA_IO_H_
#define _IBPEP_FASTA_IO_H_

#include <assert.h>
#include <string>

#if !defined(NO_STD_NAMESPACE)
using namespace std;
#endif

class fasta_entry {
  std::string defline_;
  std::string sequence_;
public:
  fasta_entry(std::string const & seq="", std::string const & dl="") {
    defline_ = dl;
    sequence_ = seq;
  }
  ~fasta_entry() {}
  std::string const & sequence() const {
    return sequence_;
  }
  std::string const & defline() const {
    return defline_;
  }
  void sequence(std::string const & seq) {
    sequence_ = seq;
  }
  void defline(std::string const & dl) {
    defline_ = dl;
  }
  void uppercase();
  void lowercase();
  void read(istream & is);
  void write(ostream & os) const;
};

ostream & operator<<(ostream & os, fasta_entry const & fe);
istream & operator>>(istream & is, fasta_entry & fe);

// #include "fasta_io.t"

#endif

