/**************************************************************************
 * This code is part of the supporting infrastructure for ATA Mapper. 
 * Copyright (C) 2002,2003,2004 Applera Corporation. All rights reserved.
 * Author: Nathan Edwards
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received (LICENSE.txt) a copy of the GNU General Public 
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *************************************************************************/

#include "fileStar.h"
#include <iostream>

#if !defined(NO_STD_NAMESPACE)
using namespace std;
#endif

FileStarFile::FileStarFile() {
  _size = _pos = 0;
}

FileStarFile::FileStarFile(std::string const &infile) {
  _size = _pos = 0;
  openBuf(infile);
}

void FileStarFile::openBuf(std::string const &fname) {

  struct stat st;
  if (stat(fname.c_str(),&st)<0) {
    perror("FileStarFile::openBuf:stat");
    exit(1);
  }
  _size = st.st_size;

#if ! defined(__CYGWIN__) 
  bufF = fopen(fname.c_str(),"r");
#else
  bufF = fopen(fname.c_str(),"rb");
#endif
  if (!bufF) {
    cerr << "couldn't open input file: " << fname << endl;
    exit(1);
  }
}

FileStarFile::~FileStarFile() {
  fclose(bufF);
  _size=_pos=0;
}

void FileStarFile::reset() {
  rewind(bufF);
  _pos=0;
}

FILE_POSITION_TYPE FileStarFile::getPos() const {
  return _pos;
}

void FileStarFile::setPos(FILE_POSITION_TYPE p) {
  FSEEK(bufF,p,SEEK_SET);
  _pos = p;
}

unsigned char FileStarFile::getCharacter(void) {
  _pos++;
  return fgetc(bufF);
}




