/**************************************************************************
 * This code is part of the supporting infrastructure for ATA Mapper. 
 * Copyright (C) 2002,2003,2004 Applera Corporation. All rights reserved.
 * Author: Nathan Edwards
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received (LICENSE.txt) a copy of the GNU General Public 
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *************************************************************************/


#ifndef _IBPEP_memory_debug_h_
#define _IBPEP_memory_debug_h_

#include <stdio.h>

#define QUOTE(a) #a

#define outputsizeof(os,type) os << "sizeof(" << QUOTE(type) << ") = " << sizeof(type) << endl

#ifdef DEBUG_MEMORY

#define NEW_DIAGNOSTIC(t,p,b,f,l) \
  fprintf(stderr,"0x%p = %s::new(%ld)[%s:%d]\n",p,t,b,f,l)

#define DELETE_DIAGNOSTIC(t,p,b,f,l) \
     fprintf(stderr,"%s::delete(0x%p,%ld)[%s:%d]\n",t,p,b,f,l)

#define ARRAYNEW_DIAGNOSTIC(t,p,b,f,l) \
  fprintf(stderr,"0x%p = %s::new[](%ld)[%s:%d]\n",p,t,b,f,l)

#define ARRAYDELETE_DIAGNOSTIC(t,p,b,f,l) \
     fprintf(stderr,"%s::delete[](0x%p,%ld)[%s:%d]\n",t,p,b,f,l)

#define MEMORY_DEBUG(type) \
\
  void* operator new(size_t bytes)\
{ \
  void *p = ::operator new(bytes); \
  NEW_DIAGNOSTIC(QUOTE(type),p,bytes,__FILE__,__LINE__);\
  return p;\
 }\
  void* operator new [] (size_t bytes)\
{ \
  void *p = ::operator new[](bytes); \
  ARRAYNEW_DIAGNOSTIC(QUOTE(type),p,bytes,__FILE__,__LINE__);\
  return p;\
 }\
\
  void* operator new (unsigned int bytes, void * const & p0)\
{ \
  void *p = ::operator new (bytes,p0); \
  NEW_DIAGNOSTIC(QUOTE(type),p,bytes,__FILE__,__LINE__);\
  return p;\
 }\
\
  void  operator delete(void* p, size_t bytes)\
{ ::operator delete(p);\
  DELETE_DIAGNOSTIC(QUOTE(type),p,bytes,__FILE__,__LINE__);\
 }\
\
  void  operator delete[](void* p, size_t bytes)\
{ ::operator delete[](p);\
  ARRAYDELETE_DIAGNOSTIC(QUOTE(type),p,bytes,__FILE__,__LINE__);\
 }\


#else 

#define MEMORY_DEBUG(type)

#endif

#endif
