/**************************************************************************
 * This code is part of the supporting infrastructure for ATA Mapper. 
 * Copyright (C) 2002,2003,2004 Applera Corporation. All rights reserved.
 * Author: Nathan Edwards
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received (LICENSE.txt) a copy of the GNU General Public 
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *************************************************************************/

#ifndef _IBPEP_TYPES_H_
#define _IBPEP_TYPES_H_

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>

#if defined(__linux) && defined(_FILE_OFFSET_BITS) && _FILE_OFFSET_BITS == 64
    typedef __off64_t FILE_POSITION_TYPE;
    typedef __off64_t FILE_SIZE_TYPE;
#   define FSEEK fseeko
#   define FTELL ftello
#   include <strstream>
#   include <values.h>
    typedef long long unsigned int bigword;
#   define ASCTIME(s,t) char s[1024]; asctime_r(t,s)
#   define GETPAGESIZE getpagesize()
#   define DRAND48 drand48()
#elif defined(__linux)
    typedef __off_t FILE_POSITION_TYPE;
    typedef __off_t FILE_SIZE_TYPE;
#   define FSEEK fseek
#   define FTELL ftell
#   include <strstream>
#   include <values.h>
    typedef long long unsigned int bigword;
#   define ASCTIME(s,t) char *s; s = asctime(t)
#   define GETPAGESIZE getpagesize()
#   define DRAND48 drand48()
#elif defined(__alpha)
    typedef off_t FILE_POSITION_TYPE;
    typedef off_t FILE_SIZE_TYPE;
#   define FSEEK fseek
#   define FTELL ftell
#   include <iostream>
#   include <strstream>
#   include <values.h>
    typedef long unsigned int bigword;
#   define ASCTIME(s,t) char s[1024]; s = asctime_r(t,s)
#   define GETPAGESIZE getpagesize()
#   define DRAND48 drand48()
#elif defined(_AIX)
    typedef off_t FILE_POSITION_TYPE;
    typedef off_t FILE_SIZE_TYPE;
#   define FSEEK fseek
#   define FTELL ftell
#   include <strstream>
#   include <values.h>
    typedef long unsigned int bigword;
#   define ASCTIME(s,t) char s[1024]; asctime_r(t,s)
#   define GETPAGESIZE getpagesize()
#   define DRAND48 drand48()
#elif defined(__CYGWIN__)
    typedef off_t FILE_POSITION_TYPE;
    typedef off_t FILE_SIZE_TYPE;
#   define FSEEK fseek
#   define FTELL ftell
#   include <sstream>
#   define istrstream istringstream
#   define ostrstream ostringstream
#   define MAXINT ((int)(~(1U<<31)))
    typedef long long unsigned int bigword;
#   define ASCTIME(s,t) char s[1024]; asctime_r(t,s)
#   define GETPAGESIZE getpagesize()
#   define DRAND48 drand48()
#elif defined(__MINGW32__)
    typedef off_t FILE_POSITION_TYPE;
    typedef off_t FILE_SIZE_TYPE;
#   define FSEEK fseek
#   define FTELL ftell
#   include <sstream>
#   define istrstream istringstream
#   define ostrstream ostringstream
#   define MAXINT ((int)(~(1U<<31)))
    typedef long long unsigned int bigword;
#   define ASCTIME(s,t) s = asctime(t)
#   define GETPAGESIZE 8192
#   define DRAND48 ((double)rand()/RAND_MAX)
#   define srand48(s) srand(s)
#endif


int compare(FILE_POSITION_TYPE const &, FILE_POSITION_TYPE const &);
#endif
