//WinBLAST is a graphical front-end for NCBI BLAST.
//Copyright (C) 2003 Alan Li, alanli@bioinformatics.org
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.Drawing;
using System.Drawing.Printing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;

namespace WinBLAST
{
	/// <summary>
	/// Summary description for BLASTResults.
	/// </summary>
	public class BLASTResults : System.Windows.Forms.Form
	{
		private System.Windows.Forms.SaveFileDialog saveFileDialog1;
		internal System.Windows.Forms.TextBox blastResult;

		private PrintDocument m_printDoc = null;
		private PageSettings m_pageSettings = null;
		private PrinterSettings m_printerSettings = null;
		private int m_lineToPrint = 0;

		private System.Windows.Forms.MainMenu m_menu;
		private System.Windows.Forms.MenuItem fileMenuItem;
		private System.Windows.Forms.MenuItem pageSetup;
		private System.Windows.Forms.MenuItem printPreview;
		private System.Windows.Forms.MenuItem exit;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem saveAs;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem printDocument;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public BLASTResults()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(BLASTResults));
			this.saveFileDialog1 = new System.Windows.Forms.SaveFileDialog();
			this.blastResult = new System.Windows.Forms.TextBox();
			this.m_menu = new System.Windows.Forms.MainMenu();
			this.fileMenuItem = new System.Windows.Forms.MenuItem();
			this.saveAs = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.pageSetup = new System.Windows.Forms.MenuItem();
			this.printDocument = new System.Windows.Forms.MenuItem();
			this.printPreview = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.exit = new System.Windows.Forms.MenuItem();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.SuspendLayout();
			// 
			// saveFileDialog1
			// 
			this.saveFileDialog1.DefaultExt = "txt";
			this.saveFileDialog1.Filter = "Text files (*.txt)|All Files (*.*)";
			// 
			// blastResult
			// 
			this.blastResult.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.blastResult.Font = new System.Drawing.Font("Lucida Sans Unicode", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.blastResult.Location = new System.Drawing.Point(8, 8);
			this.blastResult.Multiline = true;
			this.blastResult.Name = "blastResult";
			this.blastResult.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.blastResult.Size = new System.Drawing.Size(584, 496);
			this.blastResult.TabIndex = 0;
			this.blastResult.Text = "";
			// 
			// m_menu
			// 
			this.m_menu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																				   this.fileMenuItem});
			// 
			// fileMenuItem
			// 
			this.fileMenuItem.Index = 0;
			this.fileMenuItem.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						 this.saveAs,
																						 this.menuItem2,
																						 this.pageSetup,
																						 this.printDocument,
																						 this.printPreview,
																						 this.menuItem3,
																						 this.exit});
			this.fileMenuItem.Text = "File";
			// 
			// saveAs
			// 
			this.saveAs.Index = 0;
			this.saveAs.Text = "Save As...";
			this.saveAs.Click += new System.EventHandler(this.saveAs_Click);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 1;
			this.menuItem2.Text = "-";
			// 
			// pageSetup
			// 
			this.pageSetup.Index = 2;
			this.pageSetup.Text = "Page Setup...";
			this.pageSetup.Click += new System.EventHandler(this.pageSetup_Click);
			// 
			// printDocument
			// 
			this.printDocument.Index = 3;
			this.printDocument.Shortcut = System.Windows.Forms.Shortcut.CtrlP;
			this.printDocument.Text = "Print...";
			this.printDocument.Click += new System.EventHandler(this.printDocument_Click);
			// 
			// printPreview
			// 
			this.printPreview.Index = 4;
			this.printPreview.Text = "Print Preview";
			this.printPreview.Click += new System.EventHandler(this.printPreview_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 5;
			this.menuItem3.Text = "-";
			// 
			// exit
			// 
			this.exit.Index = 6;
			this.exit.Text = "Exit";
			this.exit.Click += new System.EventHandler(this.exit_Click);
			// 
			// menuItem1
			// 
			this.menuItem1.Index = -1;
			this.menuItem1.Text = "";
			// 
			// BLASTResults
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(600, 517);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.blastResult});
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Menu = this.m_menu;
			this.Name = "BLASTResults";
			this.Text = "BLAST Results";
			this.ResumeLayout(false);

		}
		#endregion

		private void exit_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void saveAs_Click(object sender, System.EventArgs e)
		{
			saveFileDialog1.FileName = "Output.txt";
			DialogResult result = saveFileDialog1.ShowDialog();
			if( result == DialogResult.Cancel )
				return;

			string filename = saveFileDialog1.FileName;
			StreamWriter saveFile = new StreamWriter( filename );
			saveFile.Write( blastResult.Text );
			saveFile.Flush();
			saveFile.Close();		
		}

		// Printing functionality.

		// lazily initialize the print document object.
		private PrintDocument getPrintDocument()
		{
			if( m_printDoc == null )
			{
				m_printDoc = new PrintDocument();
				m_printDoc.PrintPage += new PrintPageEventHandler( l_printPageEventHandler );
			}

			// probably getting the print document for printing, so reset the 
			// line number to the beginning.
			m_lineToPrint = 0;
			return m_printDoc;
		}

		// lazily initialize the page settings.
		private PageSettings getPageSettings()
		{
			if( m_pageSettings == null )
				m_pageSettings = new PageSettings();

			return m_pageSettings;
		}

		// lazily initialize the print settings.
		private PrinterSettings getPrinterSettings()
		{
			if( m_printerSettings == null )
				m_printerSettings = new PrinterSettings();

			return m_printerSettings;
		}

		// print page event handler.
		private void l_printPageEventHandler( Object sender, PrintPageEventArgs e )
		{
			String[] printText = blastResult.Lines;
			int leftMargin = e.MarginBounds.Left;
			int topMargin = e.MarginBounds.Top;
			Font printFont = blastResult.Font;
			float linesPerPage = e.MarginBounds.Height / printFont.GetHeight( e.Graphics );
			int count = 0;
			float yPosition = 0;

			while( count < linesPerPage && m_lineToPrint < printText.Length )
			{
				yPosition = topMargin + ( count * printFont.GetHeight( e.Graphics ) );
				e.Graphics.DrawString( printText[m_lineToPrint], blastResult.Font,
					Brushes.Black, leftMargin, yPosition );
				count++;
				m_lineToPrint++;
			}

			e.HasMorePages = ( m_lineToPrint < printText.Length );
		}

		private void pageSetup_Click(object sender, System.EventArgs e)
		{
			try
			{
				PageSetupDialog pageSetupDlg = new PageSetupDialog();
				pageSetupDlg.PageSettings = getPageSettings();
				pageSetupDlg.PrinterSettings = getPrinterSettings();
				pageSetupDlg.AllowOrientation = true;
				pageSetupDlg.AllowMargins = true;
				pageSetupDlg.ShowDialog();
			}
			catch( InvalidPrinterException ex )
			{
				// TODO: handle this better when no printer is installed.
				MessageBox.Show( ex.Message );
			}
		}

		private void printPreview_Click(object sender, System.EventArgs e)
		{
			try
			{
				PrintPreviewDialog previewDlg = new PrintPreviewDialog();
				previewDlg.Document = getPrintDocument();
				previewDlg.ShowDialog();
			}
			catch( InvalidPrinterException ex )
			{
				// TODO: handle this better when no printer is installed.
				MessageBox.Show( ex.Message );
			}
		}

		private void printDocument_Click(object sender, System.EventArgs e)
		{
			PrintDocument printDoc = getPrintDocument();
			printDoc.DefaultPageSettings = getPageSettings();
			PrintDialog printDlg = new PrintDialog();
			printDlg.Document = printDoc;

			if( printDlg.ShowDialog() == DialogResult.OK )
				printDoc.Print();		
		}
	}
}
