//WinBLAST is a graphical front-end for NCBI BLAST.
//Copyright (C) 2003 Alan Li, alanli@bioinformatics.org
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.Windows.Forms;
using System.Drawing;

namespace WinBLAST
{
	public class BlastGrid : DataGrid
	{
		private static int sm_borderSize = 2;  

		public BlastGrid()
		{
			//make scrollbar visible & hook up handler 
			this.VertScrollBar.Visible = true; 
			this.VertScrollBar.VisibleChanged += new EventHandler( ShowScrollBars ); 
		}

		// override to prevent user to resize columns in grid
		protected override void OnMouseDown( MouseEventArgs e )
		{
			Point p = new Point( e.X, e.Y );
			DataGrid.HitTestInfo hti = HitTest( p );
			if( hti.Type == DataGrid.HitTestType.ColumnResize )
				return;

			base.OnMouseDown( e );
		}

		// override to prevent user to resize columns in grid
		protected override void OnMouseMove( MouseEventArgs e )
		{
			Point p = new Point( e.X, e.Y );
			DataGrid.HitTestInfo hti = HitTest( p );
			if( hti.Type == DataGrid.HitTestType.ColumnResize )
				return;
			
			base.OnMouseMove( e );
		}

		// overidden to always show the vertical scroll bar.
		private void ShowScrollBars( object sender, EventArgs e ) 
		{ 
			if( ! this.VertScrollBar.Visible ) 
			{ 
				int width = this.VertScrollBar.Width; 
				this.VertScrollBar.Location = new Point( ClientRectangle.Width - width - sm_borderSize, 
														 sm_borderSize ); 
				this.VertScrollBar.Size = new Size( width, 
													ClientRectangle.Height - sm_borderSize ); 
				this.VertScrollBar.Show();                     
			} 
		}
	}
}
