

package GttMatch;

import gt.app.GTSubTask;
import java.net.InetAddress;

// Referenced classes of package GttMatch:
//            Substitution, Traceback

abstract class Align extends GTSubTask
{

    public Align(String s, InetAddress inetaddress, String s1, int i, short word0)
    {
        super(s, inetaddress, s1, i);
        d = word0;
    }

    public String strip(String s)
    {
        boolean aflag[] = new boolean[127];
        String s1 = sub.getResidues();
        for(int i = 0; i < s1.length(); i++)
        {
            char c = s1.charAt(i);
            if(c < '`')
                aflag[c] = aflag[c + 32] = true;
            else
                aflag[c - 32] = aflag[c] = true;
        }

        StringBuffer stringbuffer = new StringBuffer(s.length());
        for(int j = 0; j < s.length(); j++)
            if(aflag[s.charAt(j)])
                stringbuffer.append(s.charAt(j));

        return stringbuffer.toString();
    }

    public String fmtscore(int i)
    {
        if(i < -8192)
            return "-Inf";
        else
            return Integer.toString(i);
    }

    public Traceback next(Traceback traceback)
    {
        return traceback;
    }

    public abstract short getScore();

    static short max(short word0, short word1)
    {
        return word0 <= word1 ? word1 : word0;
    }

    static short max(short word0, short word1, short word2)
    {
        return max(word0, max(word1, word2));
    }

    static short max(short word0, short word1, short word2, short word3)
    {
        return max(max(word0, word1), max(word2, word3));
    }

    static String padLeft(String s, int i)
    {
        int j = i - s.length();
        if(j > 0)
        {
            StringBuffer stringbuffer = new StringBuffer(i);
            for(int k = 0; k < j; k++)
                stringbuffer.append(' ');

            return stringbuffer.append(s).toString();
        } else
        {
            return s;
        }
    }

    static final long serialVersionUID = 0xb354d99b669a2d04L;
    short d;
    Traceback B0;
    Substitution sub;
    static final short NegInf = -16384;
}
