#line 2 "copyright.nw"
/*
    ALiBio: Algorithms Library for Bioinformatics
    Copyright (C) 2002 	Gianluca Della Vedova, Riccardo Dondi, Luca Fossati, 
    			Lorenzo Mariani, Patrizia Pagliarulo.
    			 	
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

http://bioinformatics.org/ALiBio

Lab. Bioinformatica
DISCo, Univ. Milano-Bicocca
via Bicocca degli Arcimboldi 8
20126 Milano (Italy)
*/
#line 1962 "data_structures/sequences.nw"
#ifndef ALIBIO_PROTEIN_INCLUDED
#define ALIBIO_PROTEIN_INCLUDED

#include <alibio/primary_structure.hpp>
#include <alibio/tertiary_structure.hpp>

namespace alibio {

#line 1981 "data_structures/sequences.nw"
class protein : public primary_structure,public tertiary_structure
{
public:
    
#line 2007 "data_structures/sequences.nw"
    //Constructor prototypes
protein();
protein(std::string s,const alphabet &a);
protein(std::string s,const alphabet &a,std::string n);
    //Member function prototypes
void set_name(std::string s);
std::string &get_name();
bool add_point(int p,float x,float y,float z);
    //Overriding function prototypes
void print();
bool set_sequence (std::string s,const alibio::alphabet &a);
    //Overriding functions for consistence
bool add_point(int p,float x,float y,float z,std::string s) { return false; }
bool resize (int l) { return false; }


#line 1986 "data_structures/sequences.nw"
private:
    
#line 1995 "data_structures/sequences.nw"
std::string name;
#line 1988 "data_structures/sequences.nw"
};

#line 2028 "data_structures/sequences.nw"
protein::protein() : primary_structure(),tertiary_structure()
{
    name="unknown";
}

#line 2040 "data_structures/sequences.nw"
protein::protein(std::string s,const alphabet &a)
    : primary_structure(s,a),tertiary_structure()
{
    name="unknown";
}

#line 2054 "data_structures/sequences.nw"
protein::protein(std::string s,const alphabet &a,std::string n) 
    : primary_structure(s,a),tertiary_structure()
{
    assert(n.length()>=0);

    name=n;
}

#line 2067 "data_structures/sequences.nw"
void protein::set_name(std::string s)
{
    assert(s.length()>=0);
 
    name=s;
}

#line 2080 "data_structures/sequences.nw"
std::string &protein::get_name()
{
    assert(name.length()>=0);

    return name;
}

#line 2094 "data_structures/sequences.nw"
bool protein::add_point(int p,float x,float y,float z)
{
    return tertiary_structure::add_point(p,x,y,z,primary_structure::get_sequence());
}

#line 2109 "data_structures/sequences.nw"
void protein::print()
{
    assert(name.length()>=0);

    std::cout << ">" << name << "\n";
    primary_structure::print();
    tertiary_structure::print(primary_structure::get_sequence());
}

#line 2130 "data_structures/sequences.nw"
bool protein::set_sequence (std::string s,const alibio::alphabet &a)
{
    if (primary_structure::set_sequence(s,a)) 
        if (tertiary_structure::resize(s.length()))
            return true;
    
    return false;
}   


#line 1973 "data_structures/sequences.nw"
}

#endif //ALIBIO_PROTEIN_INCLUDED
