#line 2 "copyright.nw"
/*
    ALiBio: Algorithms Library for Bioinformatics
    Copyright (C) 2002 	Gianluca Della Vedova, Riccardo Dondi, Luca Fossati, 
    			Lorenzo Mariani, Patrizia Pagliarulo.
    			 	
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

http://bioinformatics.org/ALiBio

Lab. Bioinformatica
DISCo, Univ. Milano-Bicocca
via Bicocca degli Arcimboldi 8
20126 Milano (Italy)
*/
#line 1769 "data_structures/sequences.nw"
#ifndef ALIBIO_RNA_INCLUDED
#define ALIBIO_RNA_INCLUDED

#include <alibio/primary_structure.hpp>
#include <alibio/secondary_structure.hpp>

namespace alibio {

#line 1788 "data_structures/sequences.nw"
class rna : public primary_structure,public secondary_structure
{
public:
    
#line 1816 "data_structures/sequences.nw"
    //Constructor prototypes
rna();
rna(std::string s,const alphabet &a);
rna(std::string s,const alphabet &a,std::string n);
    //Member function prototypes
void set_name(std::string s);
std::string &get_name();
bool add_edge(int a,int b);
    //Overriding function prototypes
void print();
bool set_sequence (std::string s,const alibio::alphabet &a);
    //Overriding functions for consistence
bool add_edge(int a,int b,std::string s) { return false; }
bool resize (int l) { return false; }
void print (std::string s) { return; } 

#line 1793 "data_structures/sequences.nw"
private:
    
#line 1802 "data_structures/sequences.nw"
std::string name;
#line 1795 "data_structures/sequences.nw"
};

#line 1837 "data_structures/sequences.nw"
rna::rna() : primary_structure(),secondary_structure(0)
{
    name="unknown";
}

#line 1851 "data_structures/sequences.nw"
rna::rna(std::string s,const alphabet &a) 
    : primary_structure(s,a),secondary_structure((primary_structure::get_sequence()).length())
{
    name="unknown";
}

#line 1866 "data_structures/sequences.nw"
rna::rna(std::string s,const alphabet &a,std::string n)
    : primary_structure(s,a),secondary_structure((primary_structure::get_sequence()).length())
{
    assert(n.length()>=0);

    name=n;
}

#line 1879 "data_structures/sequences.nw"
void rna::set_name(std::string s)
{
    assert(s.length()>=0);
 
    name=s;
}

#line 1892 "data_structures/sequences.nw"
std::string &rna::get_name()
{
    assert(name.length()>=0);

    return name;
}

#line 1906 "data_structures/sequences.nw"
bool rna::add_edge(int a,int b)
{
    return secondary_structure::add_edge(a,b,primary_structure::get_sequence());
}

#line 1921 "data_structures/sequences.nw"
void rna::print()
{
    assert(name.length()>=0);

    std::cout << ">" << name << "\n";
    primary_structure::print();
    secondary_structure::print(primary_structure::get_sequence());
}

#line 1942 "data_structures/sequences.nw"
bool rna::set_sequence (std::string s,const alibio::alphabet &a)
{
    if (primary_structure::set_sequence(s,a)) 
        if (secondary_structure::resize(s.length()))
            return true;
    
    return false;
}   


#line 1780 "data_structures/sequences.nw"
}

#endif //ALIBIO_RNA_INCLUDED
