#line 2 "copyright.nw"
/*
    ALiBio: Algorithms Library for Bioinformatics
    Copyright (C) 2002 	Gianluca Della Vedova, Riccardo Dondi, Luca Fossati, 
    			Lorenzo Mariani, Patrizia Pagliarulo.
    			 	
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

http://bioinformatics.org/ALiBio

Lab. Bioinformatica
DISCo, Univ. Milano-Bicocca
via Bicocca degli Arcimboldi 8
20126 Milano (Italy)
*/
#line 978 "data_structures/sequences.nw"
#ifndef ALIBIO_SECONDARY_STRUCTURE_INCLUDED
#define ALIBIO_SECONDARY_STRUCTURE_INCLUDED

#include <iostream>
#include <stdlib.h>
#include <string>
#include <boost/graph/adjacency_list.hpp>
#include <boost/tuple/tuple.hpp>

namespace alibio {

#line 998 "data_structures/sequences.nw"
class secondary_structure
{
public:
    
#line 1042 "data_structures/sequences.nw"
typedef 
     boost::adjacency_list<boost::vecS,boost::vecS,boost::undirectedS>
     nucleotides_graph;

#line 1002 "data_structures/sequences.nw"
    
#line 1062 "data_structures/sequences.nw"
    //Contructor prototypes
secondary_structure(int n);
    //Function prototypes
void print();
void print(std::string s);
bool add_edge(int a,int b,std::string s); 
void remove_edge(int a,int b);
nucleotides_graph &get_nucleotides_graph();
bool resize(int l);

#line 1004 "data_structures/sequences.nw"
private:
    
#line 1053 "data_structures/sequences.nw"
nucleotides_graph adjacent_nucleotides;
#line 1006 "data_structures/sequences.nw"
};

#line 1078 "data_structures/sequences.nw"
secondary_structure::secondary_structure(int n)
{
  
    if (n>=0)
        for (int i=0;i<n;i++)
            boost::add_vertex(adjacent_nucleotides);
    else {
        #ifdef DEBUG
            std::cout << "\nError: graph size must be equal or greater than zero.\n";
        #endif
    }   
}

#line 1098 "data_structures/sequences.nw"
void secondary_structure::print()
{
    std::cout << "\n---Connections between nucleotides---\n";
    boost::print_graph(adjacent_nucleotides);
}

#line 1123 "data_structures/sequences.nw"
void secondary_structure::print(std::string s)
{
    boost::graph_traits<nucleotides_graph>::out_edge_iterator ei,ei_end;
    boost::graph_traits<nucleotides_graph>::vertex_iterator ui,ui_end;
    
    std::cout << "\n---Connections between nucleotides---\n";
    if (s.length()==boost::num_vertices(adjacent_nucleotides))  
        //code inspired to boost::print_graph()
        for(boost::tie(ui,ui_end)=boost::vertices(adjacent_nucleotides);ui!=ui_end;ui++) {
            std::cout << (*ui) << "(" << s[(*ui)] << ") <--> ";
            for(boost::tie(ei,ei_end)=boost::out_edges(*ui,adjacent_nucleotides);ei!=ei_end;ei++)
                std::cout << boost::target(*ei,adjacent_nucleotides) << "(" 
                << s[boost::target(*ei,adjacent_nucleotides)] << ") ";
            std::cout << std::endl;
        }  

    else
        std::cout << "\nError: sequence and nucleotides graph are inconsistent.\n";
}

#line 1167 "data_structures/sequences.nw"
bool secondary_structure::add_edge(int a,int b,std::string s)
{
   boost::graph_traits<nucleotides_graph>::edge_descriptor e;
   bool c;
   int n=s.length();

   if ((a<0)||(b<0)||(a>=n)||(b>=n)) {
        #ifdef DEBUG
            std::cout << "\nError: nucleotide positions out of buonds.\n"
        #endif 
        return false;
    }
   
    boost::tie(e,c)=boost::edge(a,b,adjacent_nucleotides);
    if (c) {
        #ifdef DEBUG
            std::cout << "\nError: edge already present.\n"
        #endif 
        return false;
    }
  
    boost::tie(e,c)=boost::add_edge(a,b,adjacent_nucleotides);
    return c;
}

#line 1200 "data_structures/sequences.nw"
void secondary_structure::remove_edge(int a,int b)
{
    boost::remove_edge(a,b,adjacent_nucleotides);
}

#line 1209 "data_structures/sequences.nw"
secondary_structure::nucleotides_graph &secondary_structure::get_nucleotides_graph()
{
    return adjacent_nucleotides;
}

#line 1231 "data_structures/sequences.nw"
bool secondary_structure::resize(int l)
{
    int n=boost::num_vertices(adjacent_nucleotides);

    if (l<0) {
        #ifdef DEBUG
            std::cout << "\nError: graph size must be greater than zero.\n";
        #endif 
        return false;
    }

    if (l<n)
        for (int i=l;i<n;i++)
            {
                boost::clear_vertex(l,adjacent_nucleotides);
                boost::remove_vertex(l,adjacent_nucleotides);
            }
    else
        for (int i=n;i<l;i++)
    boost::add_vertex(adjacent_nucleotides);
    
    return true;
}
    

#line 992 "data_structures/sequences.nw"
}

#endif //ALIBIO_SECONDARY_STRUCTURE_INCLUDED
