#line 2 "copyright.nw"
/*
    ALiBio: Algorithms Library for Bioinformatics
    Copyright (C) 2002 	Gianluca Della Vedova, Riccardo Dondi, Luca Fossati, 
    			Lorenzo Mariani, Patrizia Pagliarulo.
    			 	
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

http://bioinformatics.org/ALiBio

Lab. Bioinformatica
DISCo, Univ. Milano-Bicocca
via Bicocca degli Arcimboldi 8
20126 Milano (Italy)
*/
#line 294 "data_structures/sequences.nw"
#ifndef ALIBIO_ALPHABET_INCLUDED
#define ALIBIO_ALPHABET_INCLUDED

#include <iostream>
#include <stdlib.h>
#include <ctype.h>
#include <string>
#include <vector>
#include <assert.h>
#include <alibio/symbol.hpp>

namespace alibio {

#line 316 "data_structures/sequences.nw"
class alphabet
{
public:
    
#line 344 "data_structures/sequences.nw"
    //Constructor prototypes
alphabet();
alphabet(std::string s);
    //Member function prototypes
void print();
bool add_symbol(symbol s);
bool remove_symbol(char c);
void set_name(std::string s);
bool find_symbol(char c) const;
bool find_symbol(std::string s) const;
symbol get_symbol(char c);
std::string &get_name();
std::vector<symbol> &get_all_symbols(); 

#line 321 "data_structures/sequences.nw"
private:
    
#line 334 "data_structures/sequences.nw"
std::vector<symbol> symbols_set;
std::string name;
#line 323 "data_structures/sequences.nw"
};

#line 362 "data_structures/sequences.nw"
alphabet::alphabet()
{
    name="unknown";
}

#line 373 "data_structures/sequences.nw"
alphabet::alphabet(std::string s)
{
    assert(s.length()>=0);
    
    name=s;
}

#line 387 "data_structures/sequences.nw"
void alphabet::print()
{
    assert(name.length()>=0);
 
    std::cout << "'" << name << "' alphabet:\n";
    for (int i=0;i<symbols_set.size();i++) {
        std::cout << symbols_set[i].get_id() << ") " 
        << symbols_set[i].get_name() << "\n"; 
    }
}

#line 407 "data_structures/sequences.nw"
bool alphabet::add_symbol(symbol s)
{  
    if (find_symbol(s.get_id())!=false) {
          
        #ifdef DEBUG
            std::cout << "\nError: symbol '" << s.get_id() 
            << "' is alredy included in '" << name << "' alphabet.\n";  
        #endif
 
        return false;
    }   

    symbols_set.push_back(s);
    return true;
}

#line 433 "data_structures/sequences.nw"
bool alphabet::remove_symbol(char c)
{
    std::vector<symbol>::iterator i;
   
    c=toupper(c);

    for (i=symbols_set.begin();i!=symbols_set.end();i++)
        if (i->get_id()==c) {
            symbols_set.erase(i);
            return true;
        }

    #ifdef DEBUG
        std::cout << "\nError: symbol '" << c << "' not found in '"
        << name << "' alphabet.\n";
    #endif
   
    return false;
}  

#line 458 "data_structures/sequences.nw"
void alphabet::set_name(std::string s)
{
    assert(s.length()>=0);
 
    name=s;
}

#line 474 "data_structures/sequences.nw"
bool alphabet::find_symbol(char c) const
{
    c=toupper(c);

    for (int i=0;i<symbols_set.size();i++)
        if (symbols_set[i].get_id()==c)
            return true;

    return false;
}

#line 495 "data_structures/sequences.nw"
bool alphabet::find_symbol(std::string s) const
{
    assert(s.length()>=0);
 
    for (int i=0;i<symbols_set.size();i++)
        if (symbols_set[i].get_name()==s)
            return true;

    return false;
}

#line 514 "data_structures/sequences.nw"
symbol alphabet::get_symbol(char c)
{
    c=toupper(c);

    for (int i=0;i<symbols_set.size();i++)
        if (symbols_set[i].get_id()==c)
            return symbols_set[i];

    symbol s; 
    return s;
}

#line 532 "data_structures/sequences.nw"
std::string &alphabet::get_name()
{
    assert(name.length()>=0);
 
    return name;
}

#line 544 "data_structures/sequences.nw"
std::vector<symbol> &alphabet::get_all_symbols()
{
    return symbols_set;
}


#line 310 "data_structures/sequences.nw"
}

#endif //ALIBIO_ALPHABET_INCLUDED
