#line 2 "copyright.nw"
/*
    ALiBio: Algorithms Library for Bioinformatics
    Copyright (C) 2002 	Gianluca Della Vedova, Riccardo Dondi, Luca Fossati, 
    			Lorenzo Mariani, Patrizia Pagliarulo.
    			 	
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

http://bioinformatics.org/ALiBio

Lab. Bioinformatica
DISCo, Univ. Milano-Bicocca
via Bicocca degli Arcimboldi 8
20126 Milano (Italy)
*/
#line 1632 "data_structures/sequences.nw"
#ifndef ALIBIO_DNA_INCLUDED
#define ALIBIO_DNA_INCLUDED

#include <alibio/primary_structure.hpp>

namespace alibio {

#line 1650 "data_structures/sequences.nw"
class dna : public primary_structure
{
public:
    
#line 1671 "data_structures/sequences.nw"
    //Constructor prototypes
dna();
dna(std::string s,const alphabet &a);
dna(std::string s,const alphabet &a,std::string n);
    //Member function prototypes
void set_name(std::string s);
std::string &get_name();
    //Overriding function prototypes
void print();

#line 1655 "data_structures/sequences.nw"
private:
    
#line 1664 "data_structures/sequences.nw"
std::string name;
#line 1657 "data_structures/sequences.nw"
};

#line 1686 "data_structures/sequences.nw"
dna::dna() : primary_structure()
{
    name="unknown";
}

#line 1698 "data_structures/sequences.nw"
dna::dna(std::string s,const alphabet &a) : primary_structure(s,a)
{
    name="unknown";
}

#line 1711 "data_structures/sequences.nw"
dna::dna(std::string s,const alphabet &a,std::string n) : primary_structure(s,a)
{
    assert(n.length()>=0);

    name=n;
}

#line 1723 "data_structures/sequences.nw"
void dna::set_name(std::string s)
{
    assert(s.length()>=0);
 
    name=s;
}

#line 1736 "data_structures/sequences.nw"
std::string &dna::get_name()
{
    assert(name.length()>=0);

    return name;
}

#line 1750 "data_structures/sequences.nw"
void dna::print()
{
    assert(name.length()>=0);

    std::cout << ">" << name << "\n";
    primary_structure::print();
}


#line 1642 "data_structures/sequences.nw"
}

#endif //ALIBIO_DNA_INCLUDED
