#line 2 "copyright.nw"
/*
    ALiBio: Algorithms Library for Bioinformatics
    Copyright (C) 2002 	Gianluca Della Vedova, Riccardo Dondi, Luca Fossati, 
    			Lorenzo Mariani, Patrizia Pagliarulo.
    			 	
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

http://bioinformatics.org/ALiBio

Lab. Bioinformatica
DISCo, Univ. Milano-Bicocca
via Bicocca degli Arcimboldi 8
20126 Milano (Italy)
*/
#line 791 "data_structures/sequences.nw"
#ifndef ALIBIO_PRIMARY_STRUCTURE_INCLUDED
#define ALIBIO_PRIMARY_STRUCTURE_INCLUDED

#include <iostream>
#include <stdlib.h>
#include <string>
#include <assert.h>
#include <ctype.h>
#include <alibio/alphabet.hpp>

namespace alibio {

#line 812 "data_structures/sequences.nw"
class primary_structure
{
public:
    
#line 839 "data_structures/sequences.nw"
    //Contructor prototypes
primary_structure();
primary_structure(std::string s,const alphabet &a);
    //Function prototypes
void print();
bool set_sequence(std::string s,const alphabet &a);
std::string &get_sequence();
#line 815 "data_structures/sequences.nw"
                                                

private:
    
#line 827 "data_structures/sequences.nw"
std::string sequence;

#line 819 "data_structures/sequences.nw"
    
#line 837 "data_structures/sequences.nw"
bool initialize (std::string &s,const alphabet &a);
#line 820 "data_structures/sequences.nw"
};

#line 862 "data_structures/sequences.nw"
bool primary_structure::initialize(std::string &s,const alphabet &a)
{
    bool c=true;
    
    assert(s.length()>=0);

    for (int i=0;i<s.length();i++) {
        s[i]=toupper(s[i]);
        if (a.find_symbol(s[i])==false) {
            #ifdef DEBUG
                std::cout << "\nError: symbol '" << s[i] << "' in position "
                << i << " is not included in '" << a.get_name() << "' alphabet.\n";
            #endif 
            c=false;
        }
    }
    return c;
}

#line 885 "data_structures/sequences.nw"
primary_structure::primary_structure()
{
    sequence="";
}

#line 902 "data_structures/sequences.nw"
primary_structure::primary_structure(std::string s,const alphabet &a)
{
    assert(s.length()>=0);
  
    if (initialize(s,a))
        sequence=s;    
    else
        sequence="";
}

#line 918 "data_structures/sequences.nw"
void primary_structure::print()
{
    assert(sequence.length()>=0);

    std::cout << sequence << "\n";
}

#line 941 "data_structures/sequences.nw"
bool primary_structure::set_sequence(std::string s,const alphabet &a)
{
    bool c;
   
    assert(s.length()>=0);
   
    c=initialize(s,a);

    if (c) 
        sequence=s;    
    
    return c;
}

#line 961 "data_structures/sequences.nw"
std::string &primary_structure::get_sequence()
{
    assert(sequence.length()>=0);

    return sequence;
}


#line 806 "data_structures/sequences.nw"
}

#endif //ALIBIO_PRIMARY_STRUCTURE_INCLUDED
